/*
    //////////////////////////////\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
  //---------------------                     ---------------------\\
 ||---------------------TURN BASED BATTLE SYSTEM--------------------||
  \\---------------------       V 1.0         ---------------------//
    \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\/////////////////////////////////
   
   By: MetalMac   --> Look on Wiki-Site to get tutorial that goes along with this script <--
   
   
   *And Thnx to Radnen and Davince for Proofreading*
   
   
   *Reminder: the only thing needed for this script to work is a blank map called "test"
   
   
   

  //----------------------------------------------------\\
 ||____________SCRIPT CALLS AND VARIABLES________________||
  \\----------------------------------------------------//
*/

//-Scripts
RequireSystemScript("time.js");
EvaluateSystemScript ("menu.js");

//-Variables
var Main_Font = GetSystemFont(); 
var Eturn = 0;
var Eliving = 0; 
var Turn = 0;
var TurnLimit = 0;
var Seltarget =0;
var Side = 1;
var Target = 0;
var Hit = 0;
var Rnd = 0;
var Attack = 0;
var AtkNow = 0;
var ETeamSize = 0;



/*
  //----------------------------------------------------\\
 ||_____________________COLORS___________________________||
  \\----------------------------------------------------//
*/

var Colorbar = new Array();
Colorbar[0] = CreateColor(150, 0, 0);  //Dark-Red
Colorbar[1] = CreateColor(200, 30, 0); //Light-Red
Colorbar[2] = CreateColor(180, 60, 0); //Dark-Tan
Colorbar[3] = CreateColor(200, 120, 0);//Light-Tan
Colorbar[4] = CreateColor(200, 190, 0);//Dark-Yellow
Colorbar[5] = CreateColor(255, 255, 0);//Light-Yellow
Colorbar[6] = CreateColor(170, 255, 0);//Light-YellowGreen
Colorbar[7] = CreateColor(100, 255, 0);//Dark-YellowGreen
Colorbar[8] = CreateColor(60, 255, 0); //Lightest-Green
Colorbar[9] = CreateColor(30, 180, 0); //Light-Green
Colorbar[10] = CreateColor(0, 85, 0);  //Dark-Green

var Yellow = CreateColor(255, 255, 0);
var White = CreateColor(255, 255, 255);

/*
  //----------------------------------------------------\\
 ||____________________STATISTICS________________________||
  \\----------------------------------------------------//
*/


function Stats (Name, Hp, Mp,Str,Sta)    
{
  this.Name = Name;   
  this.Hp = Hp;        //HP (Health Points)
  this.Mp = Mp;        //MP (Magic Points)
  this.MaxHp = Hp;    //max HP
  this.MaxMp = Mp;     //maxMP
  this.Str = Str;      //strength (attack power)
  this.Sta = Sta;      //stamina (defense)
  this.Atk = 10;      // str + weapon atk
  this.Def = 10;      // sta + armor/helmet/sheild def
  this.Level = 1;      // The players current level
  this.Exp = 0;        //exp levels
  this.Active = 0;    //is member in Party (stops members from being drawn on screen)
  this.Weapon = 1;
  this.Shield = 1;
  this.Helmet = 1; 
  this.Armor = 1;
}


/*
  //----------------------------------------------------\\
 ||_______________________Items__________________________||
  \\----------------------------------------------------//
*/

////// (has to be called before the player's party, but after statistics for player) ///////////////////



//-Weapons & Stuff

function Weapon (Name, Price, Atk)   
{
  this.Name = Name;
  this.Price = Price;
  this.Atk = Atk;
}
var Weapons = new Array();

  //-Wooden-                          Reminder: It's always best to Categorize and Organize things, especially in coding
Weapons[0] = new Weapon (" ", 0, 0); 
Weapons[1] = new Weapon ("Wooden Dagger", 20, 10);



//-Defense & Clothing 

function Helmet (Name, Price, Def)    
{
  this.Name = Name;
  this.Price = Price;
  this.Def = Def;
}
var Helmets = new Array();
Helmets[0] = new Helmet (" ", 0, 0); 
Helmets[1] = new Helmet ("Cloth Cap", 70, 10); 


function Shield (Name, Price, Def)      
{
  this.Name = Name;
  this.Price = Price;
  this.Def = Def;
}
var Shields = new Array();
Shields[0] = new Shield (" ", 0, 0); 
Shields[1] = new Shield ("Wooden Shield", 50, 10); 


function Armor (Name, Price, Def) 
{   
  this.Name = Name;
  this.Price = Price;
  this.Def = Def;
}
var Armors = new Array();
Armors[0] = new Armor (" ", 0, 0); 
Armors[1] = new Armor ("Cloth Shirt", 100, 10); 



/*
  //----------------------------------------------------\\
 ||_________________PLAYER'S PARTY_______________________||
  \\----------------------------------------------------//
*/


var Person = new Array();

Person[0] = new Stats ("Mac", 100, 150, 12, 10);   
Person[0].Active = 1;
Person[0].Def = Person[0].Sta + Helmets[1].Def + Armors[1].Def + Shields[1].Def //constructs the player's defense;
Person[0].Atk = Person[0].Str + Weapons[1].Atk;                                  //constructs the player's attack
                              
Person[1] = new Stats ("Davince", 120, 140, 10, 12);  
Person[1].Active = 1;
Person[1].Def = Person[1].Sta + Helmets[1].Def + Armors[1].Def + Shields[1].Def;
Person[1].Atk = Person[1].Str + Weapons[1].Atk;     
 
Person[2] = new Stats ("Radnen", 140, 120, 10, 12);
Person[2].Active = 1; 
Person[2].Def = Person[2].Sta + Helmets[1].Def + Armors[1].Def + Shields[1].Def;
Person[2].Atk = Person[2].Str + Weapons[1].Atk;

Person[3] = new Stats ("Neologix", 150, 100, 10, 10);
Person[3].Active = 1;
Person[3].Def = Person[3].Sta + Helmets[1].Def + Armors[1].Def + Shields[1].Def;
Person[3].Atk = Person[3].Str + Weapons[1].Atk;


//-A List of Current Party Members

var Party = new Array();
Party[0] = 0;  
Party[1] = 1;
Party[2] = 2;
Party[3] = 3;



/*
  //----------------------------------------------------\\
 ||_________________ENEMY STATISTICS_____________________||
  \\----------------------------------------------------//
*/


function Enemy (Name, Hp, Mp)    //Enemy statistics 
{
  this.Name = Name;    
  this.Hp = Hp;      
  this.MaxHp = Hp;  
  this.Mp = Mp;   
  this.MaxMp = Mp;  
  this.Atk = 0;  
  this.Def = 0;  
}

//-Enemy Parties

var Enemies = new Array();
Enemies[0] = new Enemy (" ", 0, 0); //Blank Enemy for smaller parties     
Enemies[0].Atk = 0;  
Enemies[0].Def = 0; 

Enemies[1] = new Enemy ("Thief", 50, 0);          
Enemies[1].Atk = 15;                        
Enemies[1].Def = 20;                         
Enemies[2] = new Enemy ("Guard", 80, 10);          
Enemies[2].Atk = 25;  
Enemies[2].Def = 35; 

Enemies[3] = new Enemy ("Knight", 100, 0);          
Enemies[3].Atk = 35;  
Enemies[3].Def = 40; 


//-Enemy's Team -->                 Lists combinations of enemies encountered in battle

function EnemysTeam (E1, E2, E3, E4)    
{
  this.E1 = E1;      
  this.E2 = E2;  
  this.E3 = E3;   
  this.E4 = E4;
}
var EnemyTeam = new Array();
EnemyTeam[0] = new EnemysTeam(1,1,2,2); //Contains Thieves, Guards, and Knights
EnemyTeam[1] = new EnemysTeam(1,1,0,3); //setting an enemy to 0 makes that enemy blank --> you will only get 3 enemies in the party




/*
  //----------------------------------------------------\\
 ||________________CORE PART OF SCRIPT___________________||
  \\----------------------------------------------------//
*/


function game()
{

  // -->Game Start Screen Goes Here<--
  
  // -->the main game code would go here<--
  
  Main_Font.drawText (120, 240, "Press Enter to Start");  
  FlipScreen();
  GetKey();
  BindKey (KEY_ENTER, 'BattleCode(0)', 'None()');  // <--Triggers battle
  
  
  MapEngine("test.rmp", 60); //blank map with no tileset    
}



function None()      //blank function - does nothing
{
}



function Resume()   //Keeps the game going even after battle is won
{
  Main_Font.drawText (320, 240, "You Won");
  FlipScreen();
  GetKey(); 
}



function GameOver()   //Returns to start screen after battle is lost
{
  Main_Font.drawText (200, 240, "Game Over");  //Game over - restarts the game
  FlipScreen();

  Delay(5000);  
  RestartGame();
}





/*
  //----------------------------------------------------\\
 ||_________________MAIN BATTLE CODE_____________________||
  \\----------------------------------------------------//
*/


function BattleCode(ET) // <--the code which identifies whose turn, and triggers the next function
{
  BattleIsOver = false;  // <--asks system: "is battle still going on?", and doesnt end till it equals "true"
  
  Eturn = 0;            // <--just a lil variable to decide if enemy's turn
  ETeamSize = 0;        // <--another variable for calculating size of enemy's team
  
  var ETeam = new Array(); // <--temporary array for transferring Enemy ID's from EnemyTeam to the Horde
  ETeam[0] = EnemyTeam[ET].E1;
  ETeam[1] = EnemyTeam[ET].E2;
  ETeam[2] = EnemyTeam[ET].E3;
  ETeam[3] = EnemyTeam[ET].E4;
  
	for (var i = 0; i < 4; i++) // <--loop that iterates through each enemy
	{
		if (Enemies[ETeam[i]].Hp > 0)
			{
				ETeamSize ++;  // <--Enumerates the enemy team members to get size of enemy party
			}
	}
  

  for (var i = 0; i <= 3; i++) // <--Begins the "Your Turn" part of the game
    {
      U = 3 - i;
      if ( Person[Party[U]].Hp > 0) // <--Finds the first living party member and set them as first attacker
      {
        Turn = U;
      }
    }    
    
    
  while (BattleIsOver == false)      // <--basically says: "while battle is not over, do this"
  {
    DrawBattle();           // <--draws actors & background for battles
    
    Side = 1 - Side;  //flips between 0 and 1 to choose hero's or Enemy's turn    
    if (Side == 0)     //Player's turn
    {
      Living = 0;
      for (var i = 0; i <= 3; i++)
      {
        if ( Person[Party[i]].Hp > 0) // <--finds any member in the party that's still alive
        {
          Living ++;         // <--if living = 0 then no-one alive 
          TurnLimit = i;       //last living party member in list
        }
      }
      if (Living > 0)
      {
        Battle_Menu();    // <--draws the battle menu (attack selected from there)      
      }
    }
    
    
    else                // <--Now the Enemy's turn
    {
      Eliving = 0;
      for (var i = 0; i <= 3; i++)
      {
        if ( Enemies[i].Hp > 0);  // <--finds any enemy that is still alive
        {
          Eliving ++;        //if Eliving = 0 then no-one alive 
          Elimit = i;      //last living party member in list
        }
      }
      while (Enemies[Eturn].Hp == 0)   // <--skips any dead enemies
      {
        Eturn ++;
        if (Eturn > Elimit)
        {
          Eturn = 0;
        }
      }
      if (Eliving > 0)
      {
        EnemyAtk();       // <--enemy's turn to attack
      }
    }
    FlipScreen();     //Draws everything on screen
    Delay(800);      //Because there's no animations yet this gives a similar delay to the missing anim  
  }
}





/*
  //----------------------------------------------------\\
 ||___________________BATTLE MENU________________________||
  \\----------------------------------------------------//
*/

function Battle_Menu()                  // <--Uses Sphere's system menu
{   
  var menu = new Menu();                // <--Lists choices to select from when it's player's turn
  menu.addItem ("Attack", SelectEnemy); // <--if selected, instantly starts selectenemy() function
  menu.addItem ("Exit Game", Exit); 
                       
  menu.execute (20, 320, 90,142);          //Calculates the position of the battle menu 
}


function SelectEnemy()                   // <--gives the player a choice in which enemy to attack            
{
  DrawBattle();
 var menu = new Menu();                 // <--puts the selectenemy() function on entirely new menu
  for (var i = 0; i <= 3; i++)          // <--Creates a list of enemies to attack
  {
    if (Enemies[i].Hp > 0)  
    {
      menu.addItem (Enemies[i].Name, new Function("PlayerAtk("+i+")") ); // <--adds enemy's name to the list, and when selected, player attacks them
    }
  }
  menu.execute (20, 320, 90,142);      //calculates poistion of menu 
}






/*
  //----------------------------------------------------\\
 ||______________PLAYER'S ATTACK ROUTINE_________________||
  \\----------------------------------------------------//
*/

function PlayerAtk(Sel)
{  
  Xeffect = 0;
  Yeffect = 0;
  
  DrawBattle();               // <--Draws everything on screen
  
  Main_Font.drawText (220, 25, Person[Party[Turn]].Name + " Attacks");  // <--identifies at the top of the screen whose attacking
  
  
  EnemyPos = 320 / ETeamSize;     //Calculates positions for enemy sprites/text
  Xeffect = 550;                    
  Yeffect = 40 + (Sel * EnemyPos);
  
  Attack = Person[Party[Turn]].Atk; // <--The amount of person's, with turn, attack
  Defend = Enemies[Sel].Def;         // <--The amount of selected enemy's defense
  
  
  Damage = Math.round(Attack - Defend); // <--Calculates damage made on enemy's Health, this would be more detailed with factors like luck and evasion included
  
  if (Damage < 0)
    {
      Damage = 0;    //Prevents damage from being a negative number
      Main_Font.drawText (Xeffect, Yeffect, "Miss");
    }
    
    else Main_Font.drawText (Xeffect, Yeffect, Damage);
    Enemies[sel].Hp -= Damage;   // <--Deals damage 
   
   
  if (Enemies[Sel].Hp < 0)        //Prevents enemy's hp faling below 0 (looks weird if you get negative HP)
  {
    Enemies[Sel].Hp = 0;
  }  
  
    
  Eliving = 0;
  for (var i = 0; i <= 3; i++)
  {
    if ( Enemies[i].Hp > 0)
    {
      Eliving ++;            //if Eliving = 0 then no-one alive 
    }
  }
  
  
  if (Eliving == 0)
  {
    BattleIsOver = true;   //Player wins the battle
    Resume();
  }
  
  
  Turn ++;                 //sets the next player active
  if (Turn > TurnLimit)
  {
    Turn = 0;
  }
  while ( Person[Party[Turn]].Hp == 0)  //skips any dead players
  {
    Turn ++ ;
    if (Turn > TurnLimit)
    {
      Turn = 0;
    }
  }  
}





/*
  //----------------------------------------------------\\
 ||______________ENEMY ATTACK ROUTINE____________________||
  \\----------------------------------------------------//
*/


function EnemyAtk()   //Basically, it's a copy/edit of the player's attack routine
{    
  Xeffect = 0;
  Yeffect = 0;
  
  EmyPos = 120+(Eturn * EnemyPos);                        
  Main_Font.drawText (220, 25, Enemies[Eturn].Name + " Attacks"); // <--identifies which enemy is attacking, at the top of the screen
  
  Attack = Enemies[Eturn].Atk;    //Identifes the amount of attack the enemy, with turn, has
  Rnd = Math.random()*4;    // <--Math for randomly selecting party memebers
  Target = Math.floor(Rnd);    //randomly select targets from the players party
  
  while ( Person[Party[Target]].Hp == 0)    //skips attacking any dead players and moves on to next living player
  {
    Target ++;
    if (Target > TurnLimit)
    {
      Target = 0;
    }
  }  
  
  Xeffect = 50;                  // positions for damage text
  Yeffect = 40 + (Target * 80);
  
  Defend = Person[Party[Target]].Def; // <--The amount of selected player's defense
  Damage = Math.round(Attack - Defend);
  
  
  if (Damage < 0)
    {
      Damage = 0;    //Prevents damage from being a negative number
      Main_Font.drawText (Xeffect, Yeffect, "Miss");
    }
    
    else Main_Font.drawText (Xeffect, Yeffect, Damage);
    Person[Party[Target]].hp -= Damage;   // <--Deals damage 
 
 
  if (Person[Party[Target]].Hp < 0)  //finds out if hp is less than 0  
  {
    Person[Party[Target]].Hp = 0;    //prevents hp from falling below 0 
  }  
  
  
  Living = 0;  
  for (var i = 0; i <= 3; i++)
  {
    if ( Person[Party[i]].Hp > 0)  //finds if any person in player's party is alive
    {
      Living ++;        //if living = 0 then no-one is alive 
    }
  }
  
  
  if (Living == 0)    //if no one is alive, then triggers "Game Over"
  {
    GameLver();        //Game over
  }
  
  
  Eturn ++;
  if (Eturn > Elimit)
  {
    Eturn = 0;
  }
}






/*
  //----------------------------------------------------\\
 ||_________________BATTLE GRAPHICS______________________||
  \\----------------------------------------------------//
*/
/////////////////DRAWS ALL GRAPHICS ON SCREEN/////////////////

function DrawBattle()
{

for (var i = 0; i <= 3; i++)
  {
    
    // -->draw battle background here<--
    Indx = Party[i];
    BattlePos = 50 + (i * 80);  // <--an equation used to place sprites and etc. on screen
    
    if (Person[Indx].Active > 0)
    {    
      if (Person[Indx].Hp > 0)
      {
        Main_Font.drawText (50, BattlePos, Person[Indx].Name );   // <--replace this with battle sprites
        
      }
      else
      {
        Main_Font.drawText (50, BattlePos, Person[Indx].Name );   // <--replace this with battle sprites
        Main_Font.drawText (90, BattlePos, "  KO  " );
      }
    }
    EnemyPos = 320 / ETeamSize;
    EmyPos = 50 + (i * EnemyPos);   //Draws enemies evenly across screen
    
    if (Enemies[i].Hp > 0)
    {
      Main_Font.drawText (550, EmyPos, Enemies[i].Name);          // <--replace this with battle sprites
    }
  }
  Bars(430);  //Draws the health bars
}




/*
  //----------------------------------------------------\\
 ||_________________DRAW HEALTH BARS_____________________||
  \\----------------------------------------------------//
*/

function Bars(offset)  
{
    
  for (var i = 0; i <= 3; i++)
  {
    Indx = Party[i];
    if (Person[Indx].Active > 0)
    {      
      MultiHp = Person[Indx].MaxHp / 100;             //Generates a scale factor
      MultiMp = Person[Indx].MaxMp / 100;
      Hpbar = Math.floor(Person[Indx].Hp / MultiHp);   //Converts the HP into a percentage (always 0-100)
      Mpbar = Math.floor(Person[Indx].Mp / MultiMp);
      Hpcol = Colorbar[Math.floor(Hpbar / 10)];       //Generates a number from hp betweem 0 & 10 for the bar colour array
      Mpcol = Colorbar[Math.floor(Mpbar / 10)];
        
        //Poisitions of Health and MP Bars
        Ybar = 295 + (i*45);    
        Xbar= 250;              
        Bartext = Xbar - 55;
          
      
      Main_Font.drawText (Bartext - 65, Ybar + 15, Person[Indx].Name);
      Main_Font.setColorMask(Yellow);
      Main_Font.drawText (Bartext - 65, Ybar + 30,"Level " + Person[Indx].Level);
      Main_Font.setColorMask(White);
      Main_Font.drawText (Bartext, Ybar+15, "HP " + Person[Indx].Hp);
      Main_Font.drawText (Bartext, Ybar+30, "MP " + Person[Indx].Mp);
      Rectangle(Xbar, Ybar+15, Hpbar, 10, Hpcol);  //Draws HP bar
      Rectangle(Xbar, Ybar+30, Mpbar, 10, Mpcol);  //Draws MP bar
    }
  }
}