
RequireScript("3d_engine.js");

var font = GetSystemFont();

function game()
{
  
  SetFrameRate(60);
  
  var image = LoadImage("image.png");
  
  var plane   = new Plane(new _3D(0, 0, 0),
                          new _3D(1, 1, 0), 
                          new _3D(0, 0, 0), 
                          image);
  
  var box     = new Box(new _3D(-300, 0, 0),
                        new _3D(100, 100, 100), 
                        new _3D(0, 0, 0), 
                        CreateColor(0, 255, 0));
  
  var engine = new _3DEngine();
  engine.add(plane, box);
  
  
  while (!IsKeyPressed(KEY_ESCAPE))
  {
    var cam = engine.camera;
    
    if (IsKeyPressed(KEY_W)) cam.angle.x = (cam.angle.x + 1) % 360;
    if (IsKeyPressed(KEY_S)) cam.angle.x = (cam.angle.x - 1) % 360;
    if (IsKeyPressed(KEY_A)) cam.angle.y = (cam.angle.y - 1) % 360;
    if (IsKeyPressed(KEY_D)) cam.angle.y = (cam.angle.y + 1) % 360;
    if (IsKeyPressed(KEY_E)) cam.angle.z = (cam.angle.z + 1) % 360;
    if (IsKeyPressed(KEY_F)) cam.angle.z = (cam.angle.z - 1) % 360;
    
    if (IsKeyPressed(KEY_UP))    cam.position.z += 10;
    if (IsKeyPressed(KEY_DOWN))  cam.position.z -= 10;
    if (IsKeyPressed(KEY_LEFT))  cam.position.x -= 10;
    if (IsKeyPressed(KEY_RIGHT)) cam.position.x += 10;
    if (IsKeyPressed(KEY_I))     cam.position.y -= 10;
    if (IsKeyPressed(KEY_K))     cam.position.y += 10;
    
    engine.update();
    engine.draw();
    
    
    font.drawText(10, 20, "Camera.position.x: " + cam.position.x);
    font.drawText(10, 30, "Camera.position.y: " + cam.position.y);
    font.drawText(10, 40, "Camera.position.z: " + cam.position.z);
    
    font.drawText(10, 60, "Camera.angle.x: " + cam.angle.x);
    font.drawText(10, 70, "Camera.angle.y: " + cam.angle.y);
    font.drawText(10, 80, "Camera.angle.z: " + cam.angle.z);
        
    FlipScreen();
  }
}


function Plane(position, scale, angle, image)
{
  this.image    = image;
  
  this.position = position;
  this.scale    = scale;
  this.angle    = angle;
  
  var iw = this.image.width  / 2;
  var ih = this.image.height / 2;
  
  this.vertices = [new Vertex(-iw, -ih, 0),
                   new Vertex( iw, -ih, 0),
                   new Vertex( iw,  ih, 0),
                   new Vertex(-iw,  ih, 0)];
  
}

Plane.prototype.update = function()
{
  this.angle.x += 3;
  this.angle.x %= 360;
}

Plane.prototype.draw = function()
{
  var v = this.vertices;
    
  this.image.transformBlit(v[0].screen.x, v[0].screen.y,
                           v[1].screen.x, v[1].screen.y,
                           v[2].screen.x, v[2].screen.y,
                           v[3].screen.x, v[3].screen.y);
}

function Box(position, scale, angle, color)
{
  this.color    = color;
  this.position = position;
  this.scale    = scale;
  this.angle    = angle;
  
  this.vertices = [new Vertex(-1, -1,  1),
                   new Vertex( 1, -1,  1),
                   new Vertex( 1, -1, -1),
                   new Vertex(-1, -1, -1),
                   new Vertex(-1,  1,  1),
                   new Vertex( 1,  1,  1),
                   new Vertex( 1,  1, -1),
                   new Vertex(-1,  1, -1)];
}

Box.prototype.update = function()
{
  this.angle.y += 3;
  this.angle.y %= 360;
  
}

Box.prototype.draw = function()
{
  var v = this.vertices;
  
  Line(v[0].screen.x, v[0].screen.y, v[1].screen.x, v[1].screen.y, this.color);
  Line(v[1].screen.x, v[1].screen.y, v[2].screen.x, v[2].screen.y, this.color);
  Line(v[2].screen.x, v[2].screen.y, v[3].screen.x, v[3].screen.y, this.color);
  Line(v[3].screen.x, v[3].screen.y, v[0].screen.x, v[0].screen.y, this.color);
  
  Line(v[4].screen.x, v[4].screen.y, v[5].screen.x, v[5].screen.y, this.color);
  Line(v[5].screen.x, v[5].screen.y, v[6].screen.x, v[6].screen.y, this.color);
  Line(v[6].screen.x, v[6].screen.y, v[7].screen.x, v[7].screen.y, this.color);
  Line(v[7].screen.x, v[7].screen.y, v[4].screen.x, v[4].screen.y, this.color);
    
  Line(v[0].screen.x, v[0].screen.y, v[4].screen.x, v[4].screen.y, this.color);
  Line(v[1].screen.x, v[1].screen.y, v[5].screen.x, v[5].screen.y, this.color);
  Line(v[2].screen.x, v[2].screen.y, v[6].screen.x, v[6].screen.y, this.color);
  Line(v[3].screen.x, v[3].screen.y, v[7].screen.x, v[7].screen.y, this.color);
}






















