
var image = LoadImage("image.png");


function game()
{
  SetFrameRate(60);
  
  var p = new Array();
  
  for (var i = 0; i < 4; ++i)
    p.push(new Point(Math.random() * GetScreenWidth(),
                       Math.random() * GetScreenHeight(),
                       Math.random() * 360, 2));
  
  
	while (!IsKeyPressed(KEY_ESCAPE))
	{
    for (var i = 0; i < 4; ++i)
	    p[i].update();
	  
	  image.transformBlit(p[0].x, p[0].y, p[1].x, p[1].y, p[2].x, p[2].y, p[3].x, p[3].y);
	  
	  FlipScreen();
	}
}


function Point(x, y, angle, vel)
{
  this.x     = x     || 0;
  this.y     = y     || 0;
  this.angle = angle || 0;
  this.vel   = vel   || 0;
}


Point.prototype.update = function()
{
  this.x += this.vel * Math.cos(this.angle * Math.PI / 180);
  this.y += this.vel * Math.sin(this.angle * Math.PI / 180);
  
  if (this.x >= GetScreenWidth())
  {
    if (this.angle > 180)
      this.angle = 180 - this.angle;
    else
      this.angle = 180 + (360 - this.angle);

  }
  else if (this.x <= 0)
  {
    if (this.angle > 180)
      this.angle = 360 - (this.angle - 180);
    else
      this.angle = 180 - this.angle;

  }
  
  if (this.y >= GetScreenHeight() || this.y <= 0)
    this.angle = 360 - this.angle;

}

