
var EarthImg = LoadImage("earth.png");
var MoonImg = LoadImage("moon.png");
var Cursor = LoadImage("mouse.png");

var font = GetSystemFont();

var transparent = CreateColor(0,0,0,0);
var starcolor = CreateColor(222,222,222);

var c1 = CreateColor(255,255,255);
var gc1, gc2

var fps = 1000 / 30

var pointX = 120
var distance
var earthG, lunarG
var balance

var gradMulti = 0.003

var ShowEarthField = false
var ShowLunarField = false
var F1toggle = true
var F2toggle = true

function game(){
var stars = CreateStarfield();
var done = false
var lt
var EarthField = CreateEarthField();
var LunarField = CreateLunarField();

while(!done){
	lt = GetTime();
	stars.blit(0,0);
	EarthImg.blit(100,220);
	MoonImg.blit(600,235);
	
	if(ShowEarthField){
		EarthField.blit(120,220);
		font.drawText(120,220 - font.getHeight(),"Earth Gravitational Field");
	}
	if(ShowLunarField){
		LunarField.blit(120,260);
		font.drawText(604 - font.getStringWidth("Lunar Gravitational Field"),261,"Lunar Gravitational Field");
	}
	
	Rectangle(120,239,485,2,c1);
	
	if(IsMouseButtonPressed(MOUSE_LEFT)){
		if(GetMouseX() > 119 && GetMouseX() < 605){
			pointX = GetMouseX()
		}else if(GetMouseX() < 119){
			pointX = 120
		}else if(GetMouseX() > 605){
			pointX = 604
		}
	}
	
	if(pointX < 120){
			pointX = 120
		}else if(pointX > 604){
			pointX = 604
	}
	
	gc1 = EarthField.getPixel(pointX-120,0)
	gc2 = LunarField.getPixel(pointX-120,0)
	if(ShowEarthField || ShowLunarField){GradientRectangle(pointX,221,1,39,gc1,gc1,gc2,gc2);}else{Rectangle(pointX,221,1,39,c1)}
	distance = ((pointX - 120) / 484 * 100)
	earthG = GetGravityStrength((pointX - 120),81);
	lunarG = GetGravityStrength((604 - pointX),1);
	balance = (pointX == 555.6) ? 0 : earthG - lunarG
	font.drawText(20,400,"Earth Field Strength: " + earthG);
	font.drawText(20,415,"Lunar Field Strength: " + lunarG);
	font.drawText(20,430,"Distance from Earth Center: " + distance + "% ("+Math.round(distance/100 * 384400)+" km)");
	
	if(balance < 0){
		font.drawText(20,40,"Force balance: "+(balance*-1)+" towards the Moon");
	}else if(balance > 0){
		font.drawText(20,40,"Force balance: "+balance+" towards the Earth");
	}else{
		font.drawText(20,40,"Force balance: "+0+" (balanced!)");
	}
	
	if(Math.abs(balance) < 0.006){
		font.drawText(20,55,"Weightlessness");
	}else if(Math.abs(balance) < 0.1){
		font.drawText(20,55,"Gravitational pull felt");
	}else{
		font.drawText(20,55,"Gravitational pull obstructive");
	}
		
	font.drawText(5,5,"ESC: Exit | F1 and F2: Toggle Fields | Spacebar: Jump to even point | Arrows: Move");
	
	if(GetMouseX() > 100 && GetMouseX() < 140 && GetMouseY() > 220 && GetMouseY() < 260){
		font.drawText(120,260,"Earth")
	}
	
	if(GetMouseX() > 600 && GetMouseX() < 610 && GetMouseY() > 235 && GetMouseY() < 245){
		font.drawText(580,245,"Moon")
	}

	Cursor.blit(GetMouseX(),GetMouseY());
	FlipScreen();
	if(IsKeyPressed(KEY_RIGHT)) pointX += 1
	if(IsKeyPressed(KEY_LEFT)) pointX -= 1
	while(GetTime() < lt + fps){
	//Waiting script here
	
	if(IsKeyPressed(KEY_ESCAPE)) done = true
	if(IsKeyPressed(KEY_F1)){ if(!F1toggle){ShowEarthField = !ShowEarthField}; F1toggle = true}else{F1toggle = false}
	if(IsKeyPressed(KEY_F2)){ if(!F2toggle){ShowLunarField = !ShowLunarField}; F2toggle = true}else{F2toggle = false}
	if(IsKeyPressed(KEY_SPACE)) pointX = 555.6; 
	}
}


}

function CreateEarthField(){
  var ret = CreateSurface(485,1,transparent);
  var temp
  for(i=0;i<485;i++){
		temp = GetGravityStrength((i),81)
		if(temp == "Infinity") temp = gradMulti
		temp = (temp / gradMulti) * 255
		ret.setPixel(i,0,CreateColor(temp,0,255))

  }
  return ret;
}


function CreateLunarField(){
  var ret = CreateSurface(485,1,transparent);
  var temp
  for(i=0;i<485;i++){
		temp = GetGravityStrength((i),1)
		if(temp == "Infinity") temp = gradMulti
		temp = (temp / gradMulti) * 255
		ret.setPixel(484-i,0,CreateColor(temp,0,255))
  }
  return ret;
}

function GetGravityStrength(dist,weight){
	return weight / (dist  * dist);
}

var EarthOnMoonG = GetGravityStrength(484,81)
var MoonOnEarthG = GetGravityStrength(484,1)

function CreateStarfield(){
var ret = CreateSurface(640,480,transparent)
var temp
var amount = ret.width * ret.height
var sofar = 0
var timeint = 50
var lasttime = GetTime();
for(i=0;i<ret.width;i++){
	for(j=0;j<ret.height;j++){
		if(Math.random() > 0.999){
			ret.setPixel(i,j,CreateColor(starcolor.red,starcolor.green,starcolor.blue,(Math.random()*155)+100))
		}
		sofar++
		if(GetTime() > lasttime + timeint){
			font.drawText(20,20,"Loading...");
			BorderedPercentRect(20,35,300,15,(sofar / amount * 100),1,c1,c1);
			FlipScreen(); 
			lasttime = GetTime();
		}
	}
}
return ret
}

function BorderedPercentRect(x,y,w,h,percent,thick,color,bcolor){
	Rectangle(x,y,w * (percent / 100),h,color);
	Rectangle(x,y,w,thick,bcolor);
	Rectangle(x+w-thick,y,thick,h,bcolor);
	Rectangle(x,y+h-thick,w,thick,bcolor);
	Rectangle(x,y,thick,h,bcolor);

}