RequireScript("Jest_Image.js");
RequireScript("Jest_Intro.js");

var bB = 8;
var fonty = GetSystemFont();

function UseNull(i){
	if(i<0){}
	else{message("Nothing happened.")}
}

const USE_MODE= 0x0010;
const EXM_MODE= 0x0011;
const ITM_MODE= 0x0012;
const NULLMODE= 0x001F;

function room(id, im, image, items, name){
	this.id			= id;
	this.image 	=	image;
	this.imagenum=im;
	this.items	= items;
	this.name		= name;
	if(typeof im !=='number'){Abort("That is one bad room:"+name+", "+id)}
	this.factor = 1;
	this.draw		= function(){
		this.image.blit(bB,bB,this.factor)
		
		for(var i in this.items){
			this.items[i].draw();
		}
	}
	this.has=	function(str){
		for(var i in this.items){
			if(this.items[i].name==str){return true}
		}
		return false;
	}
	this.cut = function(name){
		for(var i in this.items){
			if(this.items[i].name==name){
				this.items.splice(i, 1);
				break;
			}
		}
	}
}

function move(id){
	while(Mouse.L){Mouse.refresh()}
	if(Game.room.id==id) {return true}
	for(var i in rooms){
		if(rooms[i].id==id){
			Game.room = rooms[i];
			sounds.playByRoom();
			return true;
		}
	}
	return false;
}

function burn(obj, name, description, image, mes, i){
					if(i<0) {return true}
					if(Game.items[i].name=="Matches"){
						if(Game.numMatches){
							Game.numMatches--;
							if(Game.numMatches==1){
							message("You struck the match, but it fizzled out! It's not surprising with matches this old, really.");
							}
							else{
								obj.name=name; 
								obj.description=description; 
								obj.image = image.createSurface();
								message(mes); 
							}
							Game.items[i].description = "A book of matches. It's got the name of an old cigarette company on it. There are "+Game.numMatches+" matches left.";
						}
					}
				}

function message(a){
	var mes = {description: a};
	while(Mouse.L){Mouse.refresh()}
	examine(mes)
	//Abort(a);
}

function doorMove(a, b){
	if(a<0){move(b)}
	else{
		while(Mouse.L){Mouse.refresh()}
		examine({description:"Nothing happened."})
	}
	
}
function examine(it, mw){
var one = false;
if(!mw) {var mw = GetScreenWidth()-(bB*3); }
	do{
		Game.room.draw();
		Interface.draw();	
		Rectangle(bB, 128+(bB*2), GetScreenWidth()-(bB*2), GetScreenHeight()-128-(bB*3), Colors.palegold);
		for(var i = 0; i*15<GetScreenHeight()-128-(bB*3); i++){	
			OutlinedRectangle(bB+16, 128+38+(i*15), GetScreenWidth()-(bB*2)-32, 3, Colors.black, 1);
		}
		var text = splitLines(it.description, mw);
		for(var i in text){
			fonty.drawText(bB*2, 128+26+(i*15), text[i]);
		}
		
		propertyWindow.WS.drawWindow(bB, 128+(bB*3), GetScreenWidth()-(bB*2), GetScreenHeight()-128-(bB*4));
		Mouse.refresh(true);
		Mouse.setMode();
			//To Prevent Flicker when exiting:
		if(!Mouse.L){
			DrawScreen();
		}	//I'm sure I could pick apart the exact control flow where examine() is being called to figure this out. But I don't feel like it.
	
	}while(!Mouse.L);
	while(Mouse.L){Mouse.refresh()}
}
						//1, 2, 3, 4, 5, 		6, 		 7, 	8, 9,	A
function item(x, y, w, h, name, im, image, use, r, d, f, ignoreClear){
if(typeof im !=='number'&&typeof im !=='string'){Abort("That is one bad item:"+name+", "+im)}
	
	this.x = x;
	this.y = y;
	this.w = w;
	this.h = h;
	this.factor 		= (f?f:2);
	if(f) {
		this.image			= scaleSurface(image.createSurface(), this.factor);
	}
	
	this.imagenum		= im;
	
	this.dat				= 0;
	
	this.ignoreClear= (ignoreClear==undefined?false:true);//glitchy-ass member!
	this.name				= name;
	this.use				= use;
	this.removable	= r;
	this.description= d;
	this.funcstring	= this.use+" "; 
	
}
item.prototype.draw = function(){
		if(this.factor!=1&&false){
			this.image.zoomBlit(this.x+bB, this.y+bB, this.factor);
		}
		else {
			this.image.blit(this.x+bB,this.y+bB);
		}
	}

function itemCheck(){
	for(var i = Game.room.items.length; i>=0; i--){

		if(Mouse.within(Game.room.items[i], i)&&Mouse.L){
			switch(Game.mode){
				case USE_MODE: 
					var it = Game.room.items[i];
					if(it.use(-1)&&it.removable){
						Game.items.push(new item(it.x, it.y, it.w, it.h, it.name, it.imagenum, it.image.createImage(), it.use, it.removable, it.description, 1));
						Game.room.items.splice(i--, 1);
						continue;
					}
				break;
				case EXM_MODE: 
					while(Mouse.L){Mouse.refresh()}
					examine(Game.room.items[i]);
				break;
				case ITM_MODE:
					Game.room.items[i].use(Game.select);
					//Game.mode = NULLMODE;
				break;
			}
		}
	}
}

var Interface	=	{
//192, 128
	scroll: -1,
	arrow: LoadImage("chrome/arrow.tga"),
	draw	:	function(){
		var BI = propertyWindow.BI;
		if(Mouse.within({x: 192+(bB*3), y:bB, w:192, h:128})){
		//if(debug||true) {fonty.drawText(10,10,"MJ-12 is cool. Scroll ="+this.scroll)}
    if(GetNumMouseWheelEvents()>0){
			while( GetNumMouseWheelEvents()){
			var event = GetMouseWheelEvent();
			}
			this.scroll-=(event==MOUSE_WHEEL_UP)?1:-1;
			if(this.scroll>Game.items.length-1){
				this.scroll=Math.max(Game.items.length-7, -1);
			}
			else if(this.scroll<-1){this.scroll=-1};
		}	
		}
		for(var i = 0; i < 128/BI.height; i++){
			BI.blit(192+(bB*3), bB+(i*BI.height));
			if(this.scroll<Game.items.length-7){
				this.arrow.blit(240,120);
			}
			if(!i){
				fonty.drawText(192+(bB*6), bB, "Property");
			}
			else if(i==1){}
			else if(((i-1)+this.scroll)<Game.items.length){
				fonty.drawText(192+(bB*5), bB+((i-1)*BI.height), Game.items[(i-1)+this.scroll].name);

				if(Mouse.within({x: 192+(bB*4), y: 4+bB+(((i-2))*BI.height), w: 96, h:16})&&Mouse.L){
					
					
					
					switch(Game.mode){
					case USE_MODE: 
						Game.select = (i-1)+this.scroll;
						Game.mode		= ITM_MODE;
						Mouse.setMode(true);
					break;
					case EXM_MODE:
						Game.select = (i-1)+this.scroll;
						message(Game.items[Game.select].description);
					break;
					case ITM_MODE:
					if(((i-1)+this.scroll)!=Game.select){
							Game.items[(i-1)+this.scroll].use(Game.select)
						}
					break;
					
					}
				}
			}
		}
		
		//Item Display Window
		
		if(Game.mode==ITM_MODE){
			var im = Game.items[Game.select].image.createImage();
			var f = 1;
			while(f*im.width<96&&f*im.height<72){
				f++;
			};
			im.zoomBlit((192+(bB*3))+((96-(im.width*2))/2), (128+(bB*3))+((80-(im.height*2))/2), (2*im.width<96&&2*im.height<70)?1.9:1);
			BI.blit(192+(bB*3), GetScreenHeight()-bB-16);
			fonty.drawText(192+(bB*5), GetScreenHeight()-bB-16, Game.items[Game.select].name)
		}
		else if(debug){
			map.F1.zoomBlit((190+(bB*3)), (128+(bB*3)), 3);
		}
		Rectangle(bB, 128+(bB*3), 192, 80, Colors.palegold);
		
		BI.blit(1+bB, 130+(bB*3));
		fonty.drawText(1+(bB*2), 130+(bB*3), Game.room.name)
		
		
		propertyWindow.WS.drawWindow(192+(bB*3), bB, 96, 128);
		propertyWindow.WS.drawWindow(bB, bB, 192, 128);
		propertyWindow.WS.drawWindow(bB, 128+(bB*3), 192, 80);
		propertyWindow.WS.drawWindow(192+(bB*3), 128+(bB*3), 96, 80);
	}
}

function splitLines(s, mw){
	var text = s.split(" ");
	
	var lines = [""];
	
	var maxwidth = mw;
	var curwidth = 0;
	var e = 0;
	
	for(var i in text){
		if(curwidth+fonty.getStringWidth(text[i])<maxwidth)	{
			lines[e]+=text[i]+" ";
			curwidth+=fonty.getStringWidth(text[i]+" ");
		}
		else	{
			e++;
			lines.push(text[i]+" ");
			curwidth=fonty.getStringWidth(text[i]+" ");
		}
	}
	return lines;
}

function printString(s){
	var text;
	if(fonty.getStringWidth(text[i])<GetScreenWidth()-(bB*2)){
		text = [s];
	}
	else{
	text = splitLines(s);
	}
	
	propertyWindow.WS.drawWindow(bB, 128+(bB*2), GetScreenWidth(), 48);
	
	for(var i in text){
		
	}	
}

var Mouse = {
	x: 0,
	y: 0,
	L: false,
	R: false,
	M: false,
	cursors	: [LoadImage("cursors/main.tga"), LoadImage("cursors/glass.tga"), LoadImage("cursors/item.tga")],
	image		: LoadImage("cursors/glass.tga"),
	refresh	: function(d){
		this.x = GetMouseX();
		this.y = GetMouseY();
		this.L = IsMouseButtonPressed(MOUSE_LEFT);
		this.R = IsMouseButtonPressed(MOUSE_RIGHT);
		this.M = IsMouseButtonPressed(MOUSE_MIDDLE);
		if(d){
			this.image.blit(this.x, this.y);
		}
		if(Game.mode==NULLMODE&&!this.L){
			Game.mode=USE_MODE;
			this.setMode();
		}
	},
	
	setMode	:	function(override){
	if(!override) {if(Mouse.within({x: 192+(bB*3), y:bB, w:192, h:128})){return}}
		
    if(GetNumMouseWheelEvents()>0){
			var event = GetMouseWheelEvent();
			Game.mode+=(event==MOUSE_WHEEL_UP)?1:-1;
			if(Game.mode>Math.max(USE_MODE, EXM_MODE)){
				Game.mode=Math.min(USE_MODE, EXM_MODE);
			}
			else if(Game.mode<Math.min(USE_MODE, EXM_MODE)){
				Game.mode=Math.max(USE_MODE, EXM_MODE);
			}
    }
    if(Game.mode!=NULLMODE){
			this.image = this.cursors[Game.mode-16]
		}
	},
	
	within	: function(p, i, d){		//a function as fucked up as JavaScript is.
	/*
	The official apology (with a sprinkling of explanation) to my future self and anyone who chooses to borrow this script follows.
	
	Mouse.within returns boolean true or false, if the mouse is within the object(x, y, w, h) or
	outside it, respectively.
	But! If the object has the property 'ignoreClear', then it [i]needs[/i]	a surface object member
	known as 'image'. If the mouse is within the given bounds, but outside the image and the object
	has the ignoreClear property (and it evaluates to boolean true), Mouse.within returns false. 
	If none of that returns yet, then Mouse.within returns true if the pixel the mouse is on has an
	alpha below 2. That's because 1.6 refuses to accept an alpha of 0 on a surface with the blend
	mode set to MULTIPY when it is converted to an image. It becomes 1. Fuck you 1.6, your speed is
	so sexy but your functions are so glitchy!
	*/
		if(!p){
			if(d){Abort(i)}
			return false;
		}
		
		if(false){
			fonty.drawText(10,10,"Looking for "+(p.x+bB)+"-"+(p.x+p.w+bB)+","+p.x+"-"+(p.y+p.h+bB));
			fonty.drawText(10,20,"Mouser is at "+this.x+", "+this.y);
		}
	
		if(this.x>=p.x+bB&&this.y>=p.y+bB&&this.x<=p.x+p.w+bB&&this.y<=p.y+p.h+bB){
			if('ignoreClear'in p){
				if(!p.ignoreClear){
					return true;
				}
				if(((this.x-bB)-p.x>p.image.width-1)||((this.y-bB)-p.y>p.image.height-1)){
					return false;
				}
				var a = p.image.getPixel((this.x-bB)-p.x, (this.y-bB)-p.y);
				if(a.alpha<2){
					return false
				}
				else {return true}
			}
			else {
				return true;
			}
		
		}
		return false;
	}
}

function DrawScreen(){
	if(IsKeyPressed(KEY_BACKSPACE)){
		if(GetTime()-Game.LF<1000){}
		else{
			var surfy = GrabSurface(0,0,GetScreenWidth(), GetScreenHeight());
			surfy.save("unwelcome_guest-"+Game.ScreenShots+".png")
			Game.ScreenShots++;
		}
		Game.LF=GetTime();
	}
	
	FlipScreen();
}

function Death(n){
while(Mouse.L){Mouse.refresh(false)}
while(IsKeyPressed(KEY_SPACE)||IsKeyPressed(KEY_ENTER)){}
var reasons = [];
var bck;
	switch (n){
		case 0:
		break;
		case 1:
		bck = CreateSurface(0,0,Colors.clear);
		reasons.push("You are a bit tired. You lie down and close your eyes.");
		reasons.push("You sleep for several hours, at least. You awake...");
		reasons.push("But you cannot open your eyes! You cannot move! You are completely paralyzed. You can't hear, see, or even feel.");
		reasons.push("Perhaps death will one day take your mind. But it may be a long time. A long time, lost in the darkness. No body. No world. Nothing.");
		break;
		case 2:
		bck = CreateSurface(0,0,Colors.clear);
		reasons.push("You go into the dark room. You put your foot down...");
		reasons.push("And find no floor. You fall deep down in the inky darkness, and land hard.");
		reasons.push("You feel your neck bend strangely too far as your head hits first, and your body falls backwards.");
		reasons.push("The pain is horrific! You can't move, either. It seems this dark emptiness is now your final resting place.");
		break;
	}
	reasons.push("Your adventure ends here.");
	for(var e in reasons){
		while(!Mouse.L&&!IsKeyPressed(KEY_SPACE)&&!IsKeyPressed(KEY_ENTER)){
			Rectangle(bB, 160+(bB*2), GetScreenWidth()-(bB*2), GetScreenHeight()-160-(bB*3), Colors.palegold);
			for(var i = 0; i*15<GetScreenHeight()-128-(bB*3); i++){	
				OutlinedRectangle(bB+16, 160+38+(i*15), GetScreenWidth()-(bB*2)-32, 3, Colors.black, 1);
			}
			var text = splitLines(reasons[e], GetScreenWidth()-(bB*3));
			for(var i in text){
				fonty.drawText(bB*2, 160+26+(i*15), text[i]);
			}
			
			propertyWindow.WS.drawWindow(bB, 160+(bB*3), GetScreenWidth()-(bB*2), GetScreenHeight()-160-(bB*4));
		Mouse.refresh(false);
		DrawScreen();
		}
		while(Mouse.L){Mouse.refresh(false)}
		while(IsKeyPressed(KEY_SPACE)||IsKeyPressed(KEY_ENTER)){}
	}
	
RestartGame();
}