EvaluateSystemScript("time.js");
EvaluateSystemScript("colors.js");
EvaluateSystemScript("circles.js");
EvaluateScript("menu2.js");
EvaluateScript("effects.js");
//EvaluateScript("behave.js");

var ScreenWidth = GetScreenWidth();
var ScreenHeight = GetScreenHeight();
var font = LoadFont("font.rfn");

var Black = CreateColor(0,0,0,128);
var Blue = CreateColor(0,0,255,180);

var Pic = LoadImage("fly.png");
var cursor = LoadImage("mouse.png");
var ScoreFile = OpenFile("highscores.txt");

var Name = ""
var Points = 0
var Clicks = 0
var Kills = 0
var Score = 0

var Timed = true

var Highscore = new Array(0,0,0,0,0);
var Scorenames = new Array(0,0,0,0,0);

var FlyAmount = 3							//How many flies when you start?
var FlySpeedMulti = 0.05				//Multiplier for speed - be careful!
var FlySpawnRate = 3						//How many new flies are spawned when one is killed?
var FlyStartEnergyMulti = 0.4			//Multiplier for the flies' energy
var FlyTimeBonus = 20
var FlySideAvoidanceMulti = 0.0	//Multiplier for side avoidance
var MaxFlies = 200
var FlyMouseAvoidanceMulti = 5
var FlyMouseCriticalDistance = 100


var TimeRemaining = 1000 + ( MaxFlies * 600) + Math.sqrt( (MaxFlies - FlyAmount) * 100) 			//Time in miliseconds
var MaxTime = TimeRemaining
var Timelength = 100

var Weapons = new Array("Flamethrower","Missile");


	var User = new Menu();
	User.arrow = blank
	ActiveColor = CreateColor(128,128,255);
	User.mouseSupport = true; 
	User.mouse = cursor
	User.addDefaultMouseButtons(); 
	User.addImage(blank,Null);
	User.addImage(blank,Null);

	User.preRender = function(){
		UpdateFlies();
		font.drawText(5,5,"Points: " + Points);
		font.drawText(5,20,"Shots: " + Clicks);
		font.drawText(5,35,"Kills: " + Kills + "/" + MaxFlies);
		if(Timed){
		Timelength = (TimeRemaining / MaxTime) * 100
		font.drawText(5,50,"Time Remaining")
		Rectangle(font.getStringWidth("Time Remaining") + 20, 50, Timelength,font.getHeight(),Blue);}
		Rectangle(font.getStringWidth("Time Remaining") + 20,50,100,1,Blue)
		//font.drawText
		}
	User.lastTime = GetTime()
	User.postRender = function(){
		if(Timed){
		TimeRemaining -= GetTime() - User.lastTime
		User.lastTime = GetTime()}
		if(Timed){if(TimeRemaining < 0 ) User.done = true;}
		if(IsMouseButtonPressed(MOUSE_LEFT)){ LookForKill(this.mouseX,this.mouseY,(BurnMark.width * 0.5)); Clicks++}
			//LookForKill(this.mouseX,this.mouseY,5)
			UpdateBurns();
			UpdateExplosions()
			if(Kills == MaxFlies ) User.done = true;
		}
	//User.addMouseButton(MOUSE_LEFT,function(){LookForKill(this.mouseX,this.mouseY,500)},1000);

	var ScoreScreen = new Menu(5,20);
	ScoreScreen.arrow = blank
	ActiveColor = CreateColor(128,128,255);
	ScoreScreen.mouseSupport = true; 
	ScoreScreen.mouse = cursor
	ScoreScreen.addDefaultMouseButtons(); 
	ScoreScreen.delay_rate = 33
	ScoreScreen.addImage(blank,Null);
	ScoreScreen.addImage(blank,Null);
	ScoreScreen.addTextField("Your name: ",200,10,Null,font);
	ScoreScreen.addText("",Null);
	ScoreScreen.addText("Click here to save your score",AddScore,font);
	ScoreScreen.preRender = function(){
		ApplyColorMask(White);
		font.drawText(5,5,"You got a high score!");
		ScoreScreen.items[ScoreScreen.active].item.input = GetInput(ScoreScreen.items[ScoreScreen.active].item.input);
		Name = ScoreScreen.items[2].item.input
	}
	
function ShowScores(){
	
	for(i=0;i<5;i++){
		font.drawText(5,5 + (i * 15), "Rank " + (i+1) +": " + ScoreFile.read((i+1)+"Score",0) + " by " + ScoreFile.read((i+1)+"Name","Unknown"));
	}
	/*
	font.drawText(5,5, "Highest Score: " + ScoreFile.read("1Score",0) + " by " + ScoreFile.read("1Name",0) );
	font.drawText(5,20, "2nd Highest Score: " + ScoreFile.read("2Score",0) + " by " + ScoreFile.read("2Name",0) );
	font.drawText(5,35, "3rd Highest Score: " + ScoreFile.read("3Score",0) + " by " + ScoreFile.read("3Name",0) );
	font.drawText(5,50, "4th Highest Score: " + ScoreFile.read("4Score",0) + " by " + ScoreFile.read("4Name",0) );
	font.drawText(5,65, "5th Highest Score: " + ScoreFile.read("5Score",0) + " by " + ScoreFile.read("5Name",0) );
	*/
}

function AddScore(){
	if(Score > Highscore[4]){Rank = 5;
	if(Score > Highscore[3]){Rank = 4}
	if(Score > Highscore[2]){Rank = 3}
	if(Score > Highscore[1]){Rank = 2}
	if(Score > Highscore[0]){Rank = 1}
	
	Highscore.splice(Rank-1,0,1);
	Highscore[Rank-1] = Score
	Scorenames.splice(Rank-1,0,1);
	Scorenames[Rank-1] = Name
	for(i=0;i<5;i++)
		{
		ScoreFile.write( (i + 1) + "Score",Highscore[i]);
		ScoreFile.write( (i + 1) + "Name",Scorenames[i]);
		ScoreFile.flush();
		}
	}
	ScoreScreen.done = true

}	

function LoadScores(){
	for(i=0;i<5;i++){
		Highscore[i] = ScoreFile.read((i+1) + "Score",0);
		Scorenames[i] = ScoreFile.read((i+1) + "Name","Unknown");
	}
}

var StartTime
function game(){
	var done = false
	LoadScores()
	for(i=0;i<FlyAmount;i++){
		CreateFly()
	}
	StartTime = GetTime();
	User.execute();
	ApplyColorMask(White);
	if(Kills == MaxFlies){
	Score = ((Math.floor((Points*Kills*FlySpawnRate*FlyStartEnergyMulti*FlySpeedMulti/(Clicks* 20 * FlyTimeBonus)) + ((Timed ? (TimeRemaining * 5) + (2 * Points) : Points) * MaxFlies * 100 / Clicks ))))
	font.drawText(5,5,"Stage Clear! Press any key to continue...");
	font.drawText(5,35,"You got "+Points+" points!");
	font.drawText(5,50,"Total score: "+Score);
	}else if(Timed){
	Score = Math.floor(Points*Kills*FlySpawnRate*FlyStartEnergyMulti*FlySpeedMulti/(Clicks* 20* FlyTimeBonus))
	font.drawText(5,5,"Time expended! Press any key to continue...");
	font.drawText(5,20,"You killed "+Kills+" out of " + MaxFlies + " flies!");
	font.drawText(5,35,"You got "+Points+" points!");
	font.drawText(5,50,"Total score: "+Score);
	
	
	}
	FlipScreen();
	GetKey();
	if(Score > ScoreFile.read("5Score",0) ){
	ScoreScreen.execute();
	}
	ApplyColorMask(White);
	ShowScores();
	FlipScreen();
	GetKey();
	
}

function Null(){}

var Flies = new Array();
function CreateFly(){
Flies[Flies.length] = new Fly()


}

function UpdateFlies(){
ApplyColorMask(White);

for(i=0;i<Flies.length;i++)
	{
	Flies[i].draw();
	Flies[i].update();
	}

}

function LookForKill(x,y,rad){
	var i=0;
	while(i<Flies.length){
		if(Math.sqrt( ((Flies[i].x - x) * (Flies[i].x - x)) + ((Flies[i].y - y) * (Flies[i].y - y)) ) < rad ){ Flies[i].kill(i)}
		// This new looking function cuts down on calculations and uses a simpler box-collision model.
		//if((Flies[i].x - x) < rad && (Flies[i].y - y) < rad ){ Flies[i].kill(i)}
		
		//if(Math.floor(Flies[i].x - x) < rad && Math.floor(Flies[i].y - y) < rad){Flies[i].kill(i)}
		i++
	}
	;
	AddBurn(x-(cursor.width * 0.5),y-(cursor.width * 0.5),1,BurnMark);
}

function Fly(){
	this.color = Black
	this.x = Math.random() * ScreenWidth
	this.y = Math.random() * ScreenHeight
	this.concentrate = 0
	this.speedMulti = FlySpeedMulti
	this.energy = Math.random() * 1000 * FlyStartEnergyMulti
	this.xSpd = (Math.random() * 10) - 5
	this.ySpd = (Math.random() * 10) - 5
	this.smooth = 100
	this.phase = 1
	this.sideAvoidance = FlySideAvoidanceMulti
	this.mouseAvoidance = FlyMouseAvoidanceMulti
	this.mouseDistance = FlyMouseCriticalDistance
	this.label = this.energy
	this.show = true
	this.isSideAvoiding = false
	this.img = Pic
}

Fly.prototype.kill = function(index){
	AddExplosion(this.x,this.y,100,0.5,ExpAnim);
	Points += Math.floor(this.energy)
	if(Flies.length < MaxFlies){
	for(j=0;j<FlySpawnRate;j++){
		if(Flies.length + j < MaxFlies)CreateFly()}}
	this.show = false
	this.x = -100
	this.y = -100
	this.energy = -1
	++Kills
	TimeRemaining += FlyTimeBonus
	if(Flies.length > 200){Flies.splice(0,1,0)}
	
}

Fly.prototype.draw = function(){
if(this.show){
	//Rectangle(this.x,this.y,5,5,this.color);
	this.img.blit(this.x-(this.img.width*0.5),this.y-(this.img.height*0.5));
	if(GetTime() % 20 == 0) this.label = Math.round( this.energy);
	//font.drawText(this.x+4, this.y+4,/* "Energy: "+*/this.label/*+" "+"x,y: "+Math.floor(this.x)+","+Math.floor(this.y)*/);
	}
}
 
Fly.prototype.update = function(){
if(this.show){
			if(this.energy > (this.phase == 0 ? (Math.random() * 500 * FlyStartEnergyMulti) : 250))
		{
		this.energy -= Math.random() * 50
		this.energy -= this.xSpd * 0.1
		this.energy -= this.ySpd * 0.1
		if(this.phase == 0){
			this.xSpd += (Math.random() *  80)-40
			this.ySpd += (Math.random() *  80)-40
		}
		
		this.phase = 1
		
		if(this.x < 0 || this.x > ScreenWidth || this.y < 0 || this.y > ScreenHeight)
			{
			if(Math.random() > 0.5){
				if(Math.random() > 0.5){
					this.x = 0
					this.y = Math.random() * ScreenHeight
					this.xSpd = Math.random() * 200
					this.ySpd = Math.random() * 20
				}else{
					this.x = ScreenWidth
					this.y = Math.random() * ScreenHeight
					this.xSpd = Math.random() * -200
					this.ySpd = Math.random() * 20
				}
			}else{
				if(Math.random() > 0.5){
					this.y = 0
					this.x = Math.random() * ScreenWidth
					this.ySpd = Math.random() * 200
					this.xSpd = Math.random() * 20
				}else{
					this.y = ScreenHeight
					this.x = Math.random() * ScreenWidth
					this.ySpd = Math.random() * -200
					this.xSpd = Math.random() * 20
				}
			}
			this.energy = 0
			}
		this.isSideAvoiding = false
		if(this.x + this.xSpd < 100){this.xSpd+= 15  * this.sideAvoidance; this.ySpd += ((Math.random() * 30)-15) * this.sideAvoidance;this.isSideAvoiding = true}
		if(this.y + this.ySpd < 100){this.ySpd+= 15  * this.sideAvoidance; this.xSpd += ((Math.random() * 30)-15) * this.sideAvoidance;this.isSideAvoiding = true}
		if(this.x + this.xSpd > ScreenWidth - 100){this.xSpd-= 15  * this.sideAvoidance; this.ySpd += ((Math.random() *  30)-15) * this.sideAvoidance;this.isSideAvoiding = true}
		if(this.y + this.ySpd > ScreenHeight - 100){this.ySpd-= 15  * this.sideAvoidance; this.xSpd += ((Math.random() *  30)-15) * this.sideAvoidance;this.isSideAvoiding = true}
		
		if(GetDistance(this.x,this.y,GetMouseX(),GetMouseY()) < this.mouseDistance){
				//This was the old "run away" script... trade this with the "move faster" script
				
				if(this.xSpd < 0){this.xSpd += (1 + Math.random()) * this.mouseAvoidance}else{this.xSpd -= (1 + Math.random()) * this.mouseAvoidance}
				if(this.ySpd < 0){this.ySpd += (1 + Math.random()) * this.mouseAvoidance}else{this.ySpd -= (1 + Math.random()) * this.mouseAvoidance}
				
				//Gets the fly a _bit_ energetic, but not really fleeing...
				this.energy += (1 + Math.random()) * this.mouseAvoidance
				if(this.x - GetMouseX() > 0){this.xSpd += Math.random() * 10 * this.mouseAvoidance}else{this.xSpd -= Math.random() * 10 * this.mouseAvoidance}
				if(this.y - GetMouseY() > 0){this.ySpd += Math.random() * 10 * this.mouseAvoidance}else{this.ySpd -= Math.random() * 10 * this.mouseAvoidance}
	
		}
		
		//Standard "don't go near the cursor!" movement
		if(this.x - GetMouseX() > 0){this.xSpd += Math.random() * this.mouseAvoidance}else{this.xSpd -= Math.random() * this.mouseAvoidance}
		if(this.y - GetMouseY() > 0){this.ySpd += Math.random() * this.mouseAvoidance}else{this.ySpd -= Math.random() * this.mouseAvoidance}
	
		this.x += this.xSpd * this.speedMulti
		this.y += this.ySpd * this.speedMulti
		
		if(!this.isSideAvoiding){
		this.xSpd += (Math.random() * this.energy*0.06)-(this.energy*0.03)
		this.ySpd += (Math.random() * this.energy*0.06)-(this.energy*0.03)
		}
		
		this.xSpd += (Math.random() * this.energy*0.02)-(this.energy*0.01)
		this.ySpd += (Math.random() * this.energy*0.02)-(this.energy*0.01)
		this.color = Black
		
		}else{
		this.energy += Math.random() * 50
		if(this.xSpd < 0) this.xSpd += (Math.random() *  10)
		if(this.xSpd > 0) this.xSpd -= (Math.random() *  10)
		if(this.ySpd < 0) this.ySpd += (Math.random() *  10)
		if(this.ySpd > 0) this.ySpd -= (Math.random() *  10)
		this.color = Blue
		this.phase = 0
		
		this.x += this.xSpd * this.speedMulti
		this.y += this.ySpd * this.speedMulti
		}
		
		// Max Energy Cutoff
		if(this.energy > 200){
			this.energy = 200
		}
	}
}

function GetDistance(x1,y1,x2,y2){	
	return Math.sqrt( ( (x1 - x2) * (x1 - x2) ) + ( (y1 - y2) * (y1 - y2) ) )
}

//Codebank
/*

//Errant test, this makes them SWARM the mouse, dammit!
if(this.x - GetMouseX() < 0){this.xSpd += (1 + Math.random()) * this.mouseAvoidance}else{this.xSpd -= (1 + Math.random()) * this.mouseAvoidance}
if(this.y - GetMouseY() < 0){this.ySpd += (1 + Math.random()) * this.mouseAvoidance}else{this.ySpd -= (1 + Math.random()) * this.mouseAvoidance}
		

*/