//Card Dimensions: 71 * 96
//Screen Dimensions: 640 * 480

var s_flip = LoadSound("test.wav");//flip_deck.mp3");
var s_play = LoadSound("test.wav");//play_card.mp3");
var s_shuffle = LoadSound("test.wav");//shuffle_single.mp3");
var s_slap = LoadSound("test.wav");//slap_deck.mp3");

var g_stage = "start";
var g_game_finished = false;
var g_start_next_game = false;
var g_players_turn = false;

var g_pool = 100;

var i_cards = new Array(54);
i_cards[0] = LoadImage("cards/spades/2.png");
i_cards[1] = LoadImage("cards/spades/3.png");
i_cards[2] = LoadImage("cards/spades/4.png");
i_cards[3] = LoadImage("cards/spades/5.png");
i_cards[4] = LoadImage("cards/spades/6.png");
i_cards[5] = LoadImage("cards/spades/7.png");
i_cards[6] = LoadImage("cards/spades/8.png");
i_cards[7] = LoadImage("cards/spades/9.png");
i_cards[8] = LoadImage("cards/spades/10.png");
i_cards[9] = LoadImage("cards/spades/jack.png");
i_cards[10] = LoadImage("cards/spades/queen.png");
i_cards[11] = LoadImage("cards/spades/king.png");
i_cards[12] = LoadImage("cards/spades/ace.png");
i_cards[13] = LoadImage("cards/hearts/2.png");
i_cards[14] = LoadImage("cards/hearts/3.png");
i_cards[15] = LoadImage("cards/hearts/4.png");
i_cards[16] = LoadImage("cards/hearts/5.png");
i_cards[17] = LoadImage("cards/hearts/6.png");
i_cards[18] = LoadImage("cards/hearts/7.png");
i_cards[19] = LoadImage("cards/hearts/8.png");
i_cards[20] = LoadImage("cards/hearts/9.png");
i_cards[21] = LoadImage("cards/hearts/10.png");
i_cards[22] = LoadImage("cards/hearts/jack.png");
i_cards[23] = LoadImage("cards/hearts/queen.png");
i_cards[24] = LoadImage("cards/hearts/king.png");
i_cards[25] = LoadImage("cards/hearts/ace.png");
i_cards[26] = LoadImage("cards/clubs/2.png");
i_cards[27] = LoadImage("cards/clubs/3.png");
i_cards[28] = LoadImage("cards/clubs/4.png");
i_cards[29] = LoadImage("cards/clubs/5.png");
i_cards[30] = LoadImage("cards/clubs/6.png");
i_cards[31] = LoadImage("cards/clubs/7.png");
i_cards[32] = LoadImage("cards/clubs/8.png");
i_cards[33] = LoadImage("cards/clubs/9.png");
i_cards[34] = LoadImage("cards/clubs/10.png");
i_cards[35] = LoadImage("cards/clubs/jack.png");
i_cards[36] = LoadImage("cards/clubs/queen.png");
i_cards[37] = LoadImage("cards/clubs/king.png");
i_cards[38] = LoadImage("cards/clubs/ace.png");
i_cards[39] = LoadImage("cards/diamonds/2.png");
i_cards[40] = LoadImage("cards/diamonds/3.png");
i_cards[41] = LoadImage("cards/diamonds/4.png");
i_cards[42] = LoadImage("cards/diamonds/5.png");
i_cards[43] = LoadImage("cards/diamonds/6.png");
i_cards[44] = LoadImage("cards/diamonds/7.png");
i_cards[45] = LoadImage("cards/diamonds/8.png");
i_cards[46] = LoadImage("cards/diamonds/9.png");
i_cards[47] = LoadImage("cards/diamonds/10.png");
i_cards[48] = LoadImage("cards/diamonds/jack.png");
i_cards[49] = LoadImage("cards/diamonds/queen.png");
i_cards[50] = LoadImage("cards/diamonds/king.png");
i_cards[51] = LoadImage("cards/diamonds/ace.png");
//i_cards[52] = LoadImage("cards/misc/joker1.png");
//i_cards[53] = LoadImage("cards/misc/joker2.png");

function Card(suite, value, image){
	this.suite = suite;
	this.value = value;
	this.image = image;
}

function CreateDeck(jokers){
	var cd_temp = new Array(52 + jokers);
	cd_temp[0] = new Card("spades", 1, i_cards[12]);
	cd_temp[1] = new Card("spades", 2, i_cards[0]);
	cd_temp[2] = new Card("spades", 3, i_cards[1]);
	cd_temp[3] = new Card("spades", 4, i_cards[2]);
	cd_temp[4] = new Card("spades", 5, i_cards[3]);
	cd_temp[5] = new Card("spades", 6, i_cards[4]);
	cd_temp[6] = new Card("spades", 7, i_cards[5]);
	cd_temp[7] = new Card("spades", 8, i_cards[6]);
	cd_temp[8] = new Card("spades", 9, i_cards[7]);
	cd_temp[9] = new Card("spades", 10, i_cards[8]);
	cd_temp[10] = new Card("spades", 11, i_cards[9]);
	cd_temp[11] = new Card("spades", 12, i_cards[10]);
	cd_temp[12] = new Card("spades", 13, i_cards[11]);
	
	cd_temp[13] = new Card("hearts", 1, i_cards[25]);
	cd_temp[14] = new Card("hearts", 2, i_cards[13]);
	cd_temp[15] = new Card("hearts", 3, i_cards[14]);
	cd_temp[16] = new Card("hearts", 4, i_cards[15]);
	cd_temp[17] = new Card("hearts", 5, i_cards[16]);
	cd_temp[18] = new Card("hearts", 6, i_cards[17]);
	cd_temp[19] = new Card("hearts", 7, i_cards[18]);
	cd_temp[20] = new Card("hearts", 8, i_cards[19]);
	cd_temp[21] = new Card("hearts", 9, i_cards[20]);
	cd_temp[22] = new Card("hearts", 10, i_cards[21]);
	cd_temp[23] = new Card("hearts", 11, i_cards[22]);
	cd_temp[24] = new Card("hearts", 12, i_cards[23]);
	cd_temp[25] = new Card("hearts", 13, i_cards[24]);
	
	cd_temp[26] = new Card("clubs", 1, i_cards[38]);
	cd_temp[27] = new Card("clubs", 2, i_cards[26]);
	cd_temp[28] = new Card("clubs", 3, i_cards[27]);
	cd_temp[29] = new Card("clubs", 4, i_cards[28]);
	cd_temp[30] = new Card("clubs", 5, i_cards[29]);
	cd_temp[31] = new Card("clubs", 6, i_cards[30]);
	cd_temp[32] = new Card("clubs", 7, i_cards[31]);
	cd_temp[33] = new Card("clubs", 8, i_cards[32]);
	cd_temp[34] = new Card("clubs", 9, i_cards[33]);
	cd_temp[35] = new Card("clubs", 10, i_cards[34]);
	cd_temp[36] = new Card("clubs", 11, i_cards[35]);
	cd_temp[37] = new Card("clubs", 12, i_cards[36]);
	cd_temp[38] = new Card("clubs", 13, i_cards[37]);
	
	cd_temp[39] = new Card("diamonds", 1, i_cards[51]);
	cd_temp[40] = new Card("diamonds", 2, i_cards[39]);
	cd_temp[41] = new Card("diamonds", 3, i_cards[40]);
	cd_temp[42] = new Card("diamonds", 4, i_cards[41]);
	cd_temp[43] = new Card("diamonds", 5, i_cards[42]);
	cd_temp[44] = new Card("diamonds", 6, i_cards[43]);
	cd_temp[45] = new Card("diamonds", 7, i_cards[44]);
	cd_temp[46] = new Card("diamonds", 8, i_cards[45]);
	cd_temp[47] = new Card("diamonds", 9, i_cards[46]);
	cd_temp[48] = new Card("diamonds", 10, i_cards[47]);
	cd_temp[49] = new Card("diamonds", 11, i_cards[48]);
	cd_temp[50] = new Card("diamonds", 12, i_cards[49]);
	cd_temp[51] = new Card("diamonds", 13, i_cards[50]);
	
	for(var cd_a = 0; cd_a < jokers; cd_a++){
		cd_temp[52 + cd_a] = new Card("joker", 0, i_cards[52 + cd_a]);
	}
	
	return cd_temp;
}

var g_player_names = new Array(16);

function CreatePlayers(){
	g_player_names = ["freddy", "trent", "darren", "joseph"];
	var cp_temp = new Array(4);
	for(var cp_a = 0; cp_a < 4; cp_a++){
		cp_temp[cp_a] = new Object();
		var cp_random_number = Math.floor(Math.random() * g_player_names.length)
		cp_temp[cp_a].name = g_player_names[cp_random_number];
		g_player_names.splice(cp_random_number, 1);
		cp_temp[cp_a].money = 500;
		cp_temp[cp_a].stand = false;
		cp_temp[cp_a].bust = false;
		cp_temp[cp_a].cards = new Array();
	}
	return cp_temp;
}

var i_coins = LoadImage("misc/coins.png");
var g_i_coin_width = 76;
var g_i_coin_height = 76;

var i_back = LoadImage("misc/back.png");
var g_i_back_width = 71;
var g_i_back_height = 96;

var g_rs_constant_1 = 110;
var g_rs_constant_2 = Math.floor((g_rs_constant_1 / 2) - (g_i_coin_width / 2))
var g_rs_constant_3 = Math.floor((g_rs_constant_1 / 2) - (g_i_back_width / 2))

var c_green_1 = CreateColor(0, 192, 0, 255);
var c_green_2 = CreateColor(0, 128, 0, 255);

var f_money = LoadFont("money_font.rfn");

var g_deck = undefined;
var g_players = undefined;

var i_background = LoadImage("misc/background.png");
var i_title = LoadImage("misc/title.png");

var i_button_in = LoadImage("misc/button_in.png");
var i_button_out = LoadImage("misc/button_out.png");

var i_hit = LoadImage("misc/hit.png");
var i_stand = LoadImage("misc/stand.png");
var i_bust = LoadImage("misc/bust.png");

var i_cursor = LoadImage("misc/cursor.png");
var i_new = LoadImage("misc/new.png");

function RenderScene(){
	//GradientRectangle(0, 0, 640, 480, c_green_1, c_green_1, c_green_2, c_green_2);
	i_background.blit(0, 0);
	i_title.blit(450, 10);
	i_new.blit(462, 150); 
	for(var rs_a = 0; rs_a < 4; rs_a++){
		i_coins.blit((rs_a * g_rs_constant_1) + g_rs_constant_2, 390);
		f_money.drawText((rs_a * g_rs_constant_1) + 55 - (f_money.getStringWidth("$" + g_players[rs_a].money) / 2), 417, "$" + g_players[rs_a].money);
		for(var rs_b = 0; rs_b < g_players[rs_a].cards.length; rs_b++){
			if(rs_a > 0 && g_players[rs_a].bust == false && g_game_finished == false){
				i_back.blit((g_rs_constant_1 * rs_a) + g_rs_constant_3, 294 - (18 * g_players[rs_a].cards.length) + (18 * rs_b));
			}
			else{
				g_players[rs_a].cards[rs_b].image.blit((g_rs_constant_1 * rs_a) + g_rs_constant_3, 294 - (18 * g_players[rs_a].cards.length) + (18 * rs_b));
			}
		}
		if(g_players[rs_a].bust == true){
			i_bust.blit((g_rs_constant_1 * rs_a) - 20, 310);
		}
		else if(g_players[rs_a].stand == true){
			i_stand.blit((g_rs_constant_1 * rs_a) - 20, 310);
		}
	}
	
	var m_x = GetMouseX();
	var m_y = GetMouseY();
	
	
	i_button_in.blit(450, 410);
	i_button_in.blit(450, 340);
	i_button_in.blit(450, 150);
	
	if(g_stage == "game"){
		if(m_x > 450 && m_x < 630 && m_y > 410 && m_y < 470){
			i_button_in.blit(450, 410);
			if(g_players_turn == true && IsMouseButtonPressed(MOUSE_LEFT) == true && g_game_finished == false){
				HitPlayer();
			}
		}
		else{
			i_button_out.blit(450, 410);
		}
		
		if(m_x > 450 && m_x < 630 && m_y > 340 && m_y < 400){
			i_button_in.blit(450, 340);
			if(g_players_turn == true && IsMouseButtonPressed(MOUSE_LEFT) == true){
				StandPlayer();
			}
		}
		else{
			i_button_out.blit(450, 340);
		}
	
		if(m_x > 450 && m_x < 630 && m_y > 150 && m_y < 210){
			i_button_in.blit(450, 150);
			if(g_players_turn == true && IsMouseButtonPressed(MOUSE_LEFT) == true && g_game_finished == true){
				g_start_next_game = true;
				//NewGame();
			}
		}
		else{
			i_button_out.blit(450, 150);
		}
	}
	
	i_hit.blit(462, 422);
	i_stand.blit(462, 352);
	i_new.blit(462, 162); 
	
	i_cursor.blit(m_x, m_y);
}

function CalculateCardValue(player){
	var ccv_ace_count = 0;
	var ccv_points = 0;
	for(var ccv_a = 0; ccv_a < g_players[player].cards.length; ccv_a++){
		if(g_players[player].cards[ccv_a].value == 1){
			ccv_points += 11;
			ccv_ace_count += 1;
		}
		else if(g_players[player].cards[ccv_a].value >= 10){
			ccv_points += 10;
		}
		else{
			ccv_points += g_players[player].cards[ccv_a].value;
		}
	}
	if(ccv_points > 21 && ccv_ace_count > 0){
		while(ccv_points > 21 && ccv_ace_count > 0){
			ccv_ace_count--;
			ccv_points -= 10;
		}
	}
	return ccv_points;
}

function game(){
	g_players = CreatePlayers();
	NewGame();
}

function NewGame(){
	g_game_finished = false;
	g_deck = CreateDeck(0);
	ShuffleDeck();
	for(var ng_a = 0; ng_a < 4; ng_a++){
		g_players[ng_a].stand = false;
		g_players[ng_a].bust = false;
		g_players[ng_a].cards = new Array();
	}
	
	g_stage = "start";
	s_flip.play(false);
	var ng_sound = 0;
	var ng_delay_start = 0;
	var ng_loop_var = true;
	while(ng_loop_var == true){
		switch(ng_sound){
			case 0:{
				if(s_flip.isPlaying() == false){
					s_flip.play(false);
					ng_sound++;
				}
				break;
			}
			case 1:{
				if(s_flip.isPlaying() == false){
					s_slap.play(false);
					ng_sound++;
				}
				break;
			}
			case 2:{
				if(s_slap.isPlaying() == false){
					ng_delay_start = GetTime();
					ng_sound++;
				}
				break;
			}
			case 3:{
				if(ng_delay_start + 500 > GetTime()){
					s_shuffle.play(false);
					ng_sound++;
				}
				break;
			}
			case 4:{
				if(s_shuffle.isPlaying() == false){
					s_shuffle.play(false);
					ng_sound++;
				}
				break;
			}
			case 5:{
				if(s_shuffle.isPlaying() == false){
					s_play.play(false);
					//Abort(g_players[0].cards.length);
					g_players[0].cards[0] = GetCardFromDeck();
					ng_sound++;
				}
				break;
			}
			case 6:{
				if(s_play.isPlaying() == false){
					s_play.play(false);
					g_players[1].cards[0] = GetCardFromDeck();
					ng_sound++;
				}
				break;
			}
			case 7:{
				if(s_play.isPlaying() == false){
					s_play.play(false);
					g_players[2].cards[0] = GetCardFromDeck();
					ng_sound++;
				}
				break;
			}
			case 8:{
				if(s_play.isPlaying() == false){
					s_play.play(false);
					g_players[3].cards[0] = GetCardFromDeck();
					ng_sound++;
				}
				break;
			}
			case 9:{
				if(s_play.isPlaying() == false){
					s_play.play(false);
					g_players[0].cards[1] = GetCardFromDeck();
					ng_sound++;
				}
				break;
			}
			case 10:{
				if(s_play.isPlaying() == false){
					s_play.play(false);
					g_players[1].cards[1] = GetCardFromDeck();
					ng_sound++;
				}
				break;
			}
			case 11:{
				if(s_play.isPlaying() == false){
					s_play.play(false);
					g_players[2].cards[1] = GetCardFromDeck();
					ng_sound++;
				}
				break;
			}
			case 12:{
				if(s_play.isPlaying() == false){
					s_play.play(false);
					g_players[3].cards[1] = GetCardFromDeck();
					ng_loop_var = false;
				}
				break;
			}
		}
		RenderScene();
		FlipScreen();
	}
	MainLoop();
}

var g_turn_finished = false;

function GetWager(){
	for(var gw_a = 0; gw_a < 4; gw_a++){
		if(g_players[gw_a].money < 25){
			g_players[gw_a].money = 500;
		}
		g_players[gw_a].money -= 25;
	}
}

function PlayerTurn(){
	//g_players_turn = true;
	g_turn_finished = false;
	while(g_turn_finished == false){
		RenderScene();
		FlipScreen();
	}
}

function HitPlayer(){
	g_players[0].cards[g_players[0].cards.length] = GetCardFromDeck();
	s_play.play(false);
	g_turn_finished = true;
	var hp_count = CalculateCardValue(0);
	if(hp_count > 21){
		g_players[0].bust = true;
	}
}

function StandPlayer(){
	g_players[0].stand = true;
	g_turn_finished = true;
}

function MainLoop(){
	var ml_done = false;
	g_stage = "game";
	while(ml_done == false){
		GetWager();
		g_game_finished = false;
		while(g_game_finished == false){
			if(g_players[0].stand == false && g_players[0].bust == false){
				g_players_turn = true;
				PlayerTurn();
				g_players_turn = false;
			}
			for(var ml_a = 1; ml_a < 4; ml_a++){
				var abnormal_var = 0;
				if(g_players[ml_a].stand == false && g_players[ml_a].bust == false){
					abnormal_var++;
					var ml_delay_start = GetTime();
					while(ml_delay_start + 1000 > GetTime()){
						RenderScene();
						FlipScreen();
					}
					var ml_count = CalculateCardValue(ml_a);
					if(ml_count > 17){
						g_players[ml_a].stand = true;
					}
					else{
						g_players[ml_a].cards[g_players[ml_a].cards.length] = GetCardFromDeck();
						s_play.play(false);
						var ml_count = CalculateCardValue(ml_a);
						if(ml_count > 21){
							g_players[ml_a].bust = true;
						}
					}
				}
			}
			if(abnormal_var == 0){
				abnormal_var++;
				var ml_delay_start = GetTime();
				while(ml_delay_start + 1000 > GetTime()){
					RenderScene();
					FlipScreen();
				}
			}
			
			var ml_players_in = 0;
			var ml_players_playing = 0;
			
			for(var ml_b = 0; ml_b < 4; ml_b++){
				if(g_players[ml_b].bust == false){
					ml_players_playing++;
					if(g_players[ml_b].stand == false){
						ml_players_in++;
					}
				}
			}
			
			if(ml_players_in == 0){
				g_game_finished = true;
				
				var ml_winners = new Array();
				var winning_score = 0;
				
				for(var ml_c = 0; ml_c < 4; ml_c++){
					if(g_players[ml_c].bust == false){
						var ml_value = CalculateCardValue(ml_c);
						if(ml_value > winning_score){
							winning_score = ml_value;
							ml_winners = new Array();
							ml_winners[0] = ml_c;
						}
						
						else if(ml_value == winning_score){
							ml_winners[ml_winners.length] = ml_c;
						}
					}
				}
				
				var ml_winnings = g_pool / ml_winners.length;
				var ml_winnings_rounded = RoundWinnings(ml_winnings);
				
				for(var ml_d = 0; ml_d < ml_winners.length; ml_d++){
					g_players[ml_winners[ml_d]].money += ml_winnings_rounded;
				}
			}
		}
		g_start_next_game = false;
		g_players_turn = true;
		while(g_start_next_game == false){
			RenderScene();
			FlipScreen();
		}
		NewGame();
	}
}

function ShuffleDeck(){
	var sd_new_deck = new Array(52);
	for(var sd_a = 0; sd_a < 52; sd_a++){
		var sd_random_number = Math.floor(Math.random() * g_deck.length);
		sd_new_deck[sd_a] = g_deck[sd_random_number];
		g_deck.splice(sd_random_number, 1);
	}
	g_deck = sd_new_deck;
}

function GetCardFromDeck(){
	var gcfd_temp = g_deck[0];
	g_deck.shift();
	return gcfd_temp;
}

function RoundWinnings(amount){
	var rw_temp = Math.round(amount);
	var rw_temp_2 = Math.round(rw_temp / 5);
	return rw_temp_2 * 5;
}

//run Errors:
//1: Could not load sounds.
//2: Could not load cursor.png
//3: Could not load joker cards.
//4: var g_players_turn is not defined.
//5: Did not deal two cards at start, text was unalligned, YouLose() is undefined..
//6: Text still unalligned, did not deal two cards at start. Nothing happens when you bust/probaly stand, delay should be at start not end.
//7: Cards not dealt to human player at start.
//8: Debugging, button images don't show at start.
//9: Testing, var winning_score is not defined.
//10: Nothing happens at end of game, noticed bug in AI, to do with aces, it doesn't really matter so I'll probaly leave it in there.
//11: Debugging above problem.
//12: Testing fix to problem, noticed error when dishing out money.
//13: Testing, Noticed variables need to be reset after each game.
//14: winnings dished out were incorrect amount. Showed opponents cards at start of subsequential games.
//15: Winnings need to rounded to the nearest $5.
//16: Need to change something about the delays, Bug when people run out of bling bling.
//17: Perfect, pity the sounds don't play.