#ifndef VIDEO_H
#define VIDEO_H


#define EXPORT __stdcall


// Driver info
typedef struct
{
  const char* name;
  const char* author;
  const char* date;
  const char* version;
  const char* description;
} DRIVERINFO;


#include "begin_c_prototypes.h"

  extern bool EXPORT SetClippingRectangle(int x, int y, int w, int h);
  extern bool EXPORT GetClippingRectangle(int* x, int* y, int* w, int* h);

  extern HINSTANCE DriverInstance;
  extern int       ScreenWidth;
  extern int       ScreenHeight;
  extern RECT      ClippingRectangle;

  extern void GetDriverConfigFile(char* config_file);

#include "end_c_prototypes.h"


#define calculate_clipping_metrics(width, height)                \
  int image_offset_x = 0;                                        \
  int image_offset_y = 0;                                        \
  int image_blit_width = width;                                  \
  int image_blit_height = height;                                \
                                                                 \
  if (x < ClippingRectangle.left)                                \
  {                                                              \
    image_offset_x = (ClippingRectangle.left - x);               \
    image_blit_width -= image_offset_x;                          \
  }                                                              \
                                                                 \
  if (y < ClippingRectangle.top)                                 \
  {                                                              \
    image_offset_y = (ClippingRectangle.top - y);                \
    image_blit_height -= image_offset_y;                         \
  }                                                              \
                                                                 \
  if (x + (int)width > ClippingRectangle.right)           \
    image_blit_width -= (x + width - ClippingRectangle.right);   \
                                                                 \
  if (y + (int)height > ClippingRectangle.bottom)         \
    image_blit_height -= (y + height - ClippingRectangle.bottom)
// #end define


#endif
