#ifndef __SSPRITESET_H
#define __SSPRITESET_H


#include "../common/Spriteset.hpp"
#include "video.h"


class SSPRITESET
{
public:
  SSPRITESET();
  ~SSPRITESET();

  bool Load(const char* filename);

  const sSpriteset& GetSpriteset() const;

  int GetNumDirections() const;
  int GetNumFrames(int direction) const;
  IMAGE GetFrame(int direction, int frame);
  IMAGE GetFlipFrame(int direction, int frame);

  int GetFrameDelay(int direction, int frame) const;

private:
   IMAGE CreateFrameImage(int direction, int frame);
   IMAGE CreateFlipFrameImage(int direction, int frame);

private:
  sSpriteset m_Spriteset;
  IMAGE**    m_Frames;
  IMAGE**    m_FlipFrames;
};


#endif
