#ifndef SPHERE_HPP
#define SPHERE_HPP


#include "video.h"
#include "sfont.hpp"
#include "swindowstyle.hpp"


struct SSystemFiles
{
  char* font;
  char* window_style;
  char* arrow;
  char* up_arrow;
  char* down_arrow;
};


class CSphereEngine
{         
public:
  CSphereEngine();
  ~CSphereEngine();
  void Run(int num_arguments, const char** arguments);

private:
  bool Intro();
  bool MainMenu(char* game);
  bool RunGame(const char* game);
  void GetGameList(int* numgames, char*** gamelist);
  void FreeGameList(int* numgames, char*** gamelist);
  void LoadSystemObjects();
  void DestroySystemObjects();

private:
  SSystemFiles m_SystemFiles;

  char m_IntroImage[520];
  char m_IntroSound[520];

  SFONT*        m_SystemFont;
  SWINDOWSTYLE* m_SystemWindowStyle;
  IMAGE         m_SystemArrow;
  IMAGE         m_SystemUpArrow;
  IMAGE         m_SystemDownArrow;
};


#endif
