#ifndef __SFONT_H
#define __SFONT_H


#include <vector>
#include "colorspace.h"
#include "../common/Font.hpp"


class SFONT
{
public:
  SFONT();
  ~SFONT();

  bool Load(const char* filename);
  bool SetMask(RGBA color);

  bool DrawText(int x, int y, const char* text) const;
  bool DrawTextBox(int x, int y, int w, int h, int offset, const char* text) const;

  int GetMaxHeight() const;
  int GetStringWidth(const char* string) const;

private:
  struct Color
  {
    RGBA color;
    RGBA* characters[256];  // 256 pointers
  };

private:
  void Destroy();

private:
  sFont m_Font;
  int m_CurrentColor;

  std::vector<Color> m_Colors;
};


#endif
