#ifndef SCRIPT_H
#define SCRIPT_H


#include <string>
using std::string;
#include "engineinterface.hpp"
#include "colorspace.h"
#include "jsapi.h"


bool InitializeScriptSystem(IEngineInterface* interface);
bool ShutdownScriptSystem();


class CScript
{
public:
  CScript();
  ~CScript();

  bool Load(const char* filename);
  bool ExecuteFunction(const char* function);

  // these should be private
  // DO NOT USE THEM
  void SetError(const char* message);
  bool m_ShouldRender;

private:
  void InitializeSphereFunctions();
  void InitializeSphereObjects();

  static void ErrorReporter(JSContext* cx, const char* message, JSErrorReport* report);

  #define SS_FUNCTION(name, numargs) static JSBool ss##name(JSContext* cx, JSObject* obj, uintN argc, jsval* argv, jsval* rval);
  #include "ss_functions.table"
  #undef SS_FUNCTION

private:
  JSRuntime* m_Runtime;
  JSContext* m_Context;
  JSObject*  m_Global;
  JSScript*  m_Script;

  bool m_HasError;
  struct error__ {
    string message;
    string filename;
    int    line_number;
    string line;
    int    token_offset;

    string BuildMessage();
  } m_Error;

  int  m_FrameRate;
  int  m_FramesSkipped;
  int  m_IdealTime;
};



#endif
