#include <stdlib.h>
#include <string.h>
#include "animation.h"
#include "flic.hpp"
#include "render.h"
#include "inputx.h"
#include "video.h"
#include "input.h"
#include "timer.h"



////////////////////////////////////////////////////////////////////////////////

bool PlayAnimation(const char* animationfile)
{
  // open animation
  CFlicAnimation animation(animationfile);
  if (animation.IsLoaded() == false)
    return false;

  int width = animation.GetWidth();
  int height = animation.GetHeight();

  // allocate a frame buffer
  RGBA* framebuffer = new RGBA[width * height];

  // allocate an frame buffer used to store the previous frame for 
  RGBA* oldframebuffer = new RGBA[width * height];

  dword idealtime = GetTime();

  int forceframe = 0;  // when this reaches 10, force a frame draw

  while (!KeysLeft())
  {
    bool drawnonce = false;

    animation.ReadNextFrame(framebuffer);

    // render the frame if we're ahead
    while (forceframe >= 10 || idealtime > GetTime())
    {
      if (memcmp(framebuffer, oldframebuffer, width * height * sizeof(RGBA)) != 0)
      {
        // since CreateImage() is a fairly CPU-intensive function in most video drivers,
        // only allocate a new one if the buffer has changed (Animation Shop likes to duplicate frames)
        ClearScreen();
        int x = (GetScreenWidth() - width) / 2;
        int y = (GetScreenHeight() - height) / 2;
        DirectBlit(x, y, width, height, framebuffer, 1);
        FlipScreen();

        memcpy(oldframebuffer, framebuffer, width * height * sizeof(RGBA));
      }
      drawnonce = true;
      forceframe = 0;
    }

    if (!drawnonce)
      forceframe++;

    // update the time
    idealtime += animation.GetDelay();
  }

  GetKey();  // eat the key that was pressed

  // free the frame buffers
  delete[] oldframebuffer;
  delete[] framebuffer;

  return true;
}

////////////////////////////////////////////////////////////////////////////////
