#ifndef TILE_PALETTE_HPP
#define TILE_PALETTE_HPP


#include <afxwin.h>
#include "TilesetView.hpp"
#include "../common/Tileset.hpp"


class CTilePalette : public CMiniFrameWnd
{
public:
  CTilePalette(CWnd* parent, CTilesetViewHandler* handler, sTileset* tileset, CStatusBar* status_bar);
  ~CTilePalette();

  void TileChanged(int tile);
  void TilesetChanged();

  void SelectTile(int tile);
  int GetSelectedTile() const;

private:
  afx_msg void OnClose();
  afx_msg void OnSize(UINT type, int cx, int cy);

private:
  bool         m_Created;
  CTilesetView m_TilesetView;

  DECLARE_MESSAGE_MAP()
};


#endif
