#include "TilePalette.hpp"
#include "StateServer.hpp"


BEGIN_MESSAGE_MAP(CTilePalette, CMiniFrameWnd)

  ON_WM_CLOSE()
  ON_WM_SIZE()

END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////////

CTilePalette::CTilePalette(CWnd* parent, CTilesetViewHandler* handler, sTileset* tileset, CStatusBar* status_bar)
: m_Created(false)
{
  int left   = GetStateServer()->GetInt("TilePalette:left",   -1);
  int top    = GetStateServer()->GetInt("TilePalette:top",    -1);
  int right  = GetStateServer()->GetInt("TilePalette:right",  -1);
  int bottom = GetStateServer()->GetInt("TilePalette:bottom", -1);

  CRect start_rect(left, top, right, bottom);

  if (left == -1 && top == -1 && right == -1 && bottom == -1)
    start_rect = CRect(0, 0, 80, 80);

  Create(
    AfxRegisterWndClass(0, LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW)), NULL, NULL),
    "tileset",
    WS_POPUP | WS_CAPTION | WS_VISIBLE | WS_SIZEBOX | MFS_SYNCACTIVE | MFS_THICKFRAME | MFS_BLOCKSYSMENU,
    start_rect,
    parent);

  m_TilesetView.Create(status_bar, handler, this, tileset);

  m_Created = true;
  
  RECT rect;
  GetClientRect(&rect);
  OnSize(0, rect.right, rect.bottom);
}

////////////////////////////////////////////////////////////////////////////////

CTilePalette::~CTilePalette()
{
}

////////////////////////////////////////////////////////////////////////////////

void
CTilePalette::TileChanged(int tile)
{
  m_TilesetView.TileChanged(tile);
}

////////////////////////////////////////////////////////////////////////////////

void
CTilePalette::TilesetChanged()
{
  m_TilesetView.TilesetChanged();
}                            

////////////////////////////////////////////////////////////////////////////////

void
CTilePalette::SelectTile(int tile)
{
  m_TilesetView.SetSelectedTile(tile);
}

////////////////////////////////////////////////////////////////////////////////

int
CTilePalette::GetSelectedTile() const
{
  return m_TilesetView.GetSelectedTile();
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CTilePalette::OnClose()
{
  RECT rect;
  GetWindowRect(&rect);
  GetStateServer()->SetInt("TilePalette:left",   rect.left);
  GetStateServer()->SetInt("TilePalette:top",    rect.top);
  GetStateServer()->SetInt("TilePalette:right",  rect.right);
  GetStateServer()->SetInt("TilePalette:bottom", rect.bottom);
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CTilePalette::OnSize(UINT type, int cx, int cy)
{
  if (m_Created)
    m_TilesetView.MoveWindow(0, 0, cx, cy);
}

////////////////////////////////////////////////////////////////////////////////
