#include "TileObstructionDialog.hpp"
#include "resource.h"


BEGIN_MESSAGE_MAP(CTileObstructionDialog, CDialog)

  ON_BN_CLICKED(IDC_DRAW,  OnDraw)
  ON_BN_CLICKED(IDC_ERASE, OnErase)
  
  ON_COMMAND(IDC_PRESETS, OnPresets)

END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////////

CTileObstructionDialog::CTileObstructionDialog(sTile* tile)
: CDialog(IDD_OBSTRUCTIONDIALOG)
, m_RealTile(tile)
{
  m_Tile = *m_RealTile;
}

////////////////////////////////////////////////////////////////////////////////

CTileObstructionDialog::~CTileObstructionDialog()
{
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CTileObstructionDialog::OnInitDialog()
{
  SetWindowText("Obstruction Editor");

  // set the dialog to correct size

  int screen_width  = GetSystemMetrics(SM_CXSCREEN);
  int screen_height = GetSystemMetrics(SM_CYSCREEN);

  const int BUTTON_AREA_WIDTH = 100;
  int width  = 16 * 16 + GetSystemMetrics(SM_CXVSCROLL) + BUTTON_AREA_WIDTH;
  int height = 16 * 16 + GetSystemMetrics(SM_CYHSCROLL);

  RECT rect = {
    (screen_width - width) / 2,
    (screen_height - height) / 2,
    (screen_width + width) / 2,
    (screen_height + height) / 2,
  };
  AdjustWindowRectEx(&rect, GetWindowLong(m_hWnd, GWL_STYLE), FALSE, GetWindowLong(m_hWnd, GWL_EXSTYLE));
  MoveWindow(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);

  // create the actual obstruction editor
  m_TileObstructionView.Create(&m_Tile, this);
  m_TileObstructionView.MoveWindow(0, 0, width - BUTTON_AREA_WIDTH, height);
  m_TileObstructionView.SetDrawMode(true);

  // move the dialog buttons

  GetDlgItem(IDOK)->MoveWindow(width - 90, 5, 80, 30);
  GetDlgItem(IDCANCEL)->MoveWindow(width - 90, 40, 80, 30);
  GetDlgItem(IDC_DRAW)->MoveWindow(width - 90, 100, 80, 20);
  GetDlgItem(IDC_ERASE)->MoveWindow(width - 90, 120, 80, 20);
  GetDlgItem(IDC_PRESETS)->MoveWindow(width - 90, 180, 80, 30);
  CheckDlgButton(IDC_DRAW, BST_CHECKED);

  return FALSE;
}

////////////////////////////////////////////////////////////////////////////////

void
CTileObstructionDialog::OnOK()
{
  *m_RealTile = m_Tile;
  CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CTileObstructionDialog::OnDraw()
{
  m_TileObstructionView.SetDrawMode(true);
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CTileObstructionDialog::OnErase()
{
  m_TileObstructionView.SetDrawMode(false);
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CTileObstructionDialog::OnPresets()
{
  POINT point;
  GetCursorPos(&point);

  HMENU menu_ = LoadMenu(AfxGetApp()->m_hInstance, MAKEINTRESOURCE(IDR_OBSTRUCTION_PRESETS));
  HMENU menu = GetSubMenu(menu_, 0);

  UINT command = TrackPopupMenu(menu, TPM_LEFTALIGN | TPM_TOPALIGN | TPM_RETURNCMD | TPM_RIGHTBUTTON, point.x, point.y, 0, m_hWnd, NULL);

  switch (command)
  {
    case ID_OBSTRUCTIONPRESETS_UNBLOCKED:  m_TileObstructionView.Preset(TOV_PRESET_UNBLOCKED);  break;
    case ID_OBSTRUCTIONPRESETS_BLOCKED:    m_TileObstructionView.Preset(TOV_PRESET_BLOCKED);    break;
    case ID_OBSTRUCTIONPRESETS_UPPERRIGHT: m_TileObstructionView.Preset(TOV_PRESET_UPPERRIGHT); break;
    case ID_OBSTRUCTIONPRESETS_LOWERRIGHT: m_TileObstructionView.Preset(TOV_PRESET_LOWERRIGHT); break;
    case ID_OBSTRUCTIONPRESETS_LOWERLEFT:  m_TileObstructionView.Preset(TOV_PRESET_LOWERLEFT);  break;
    case ID_OBSTRUCTIONPRESETS_UPPERLEFT:  m_TileObstructionView.Preset(TOV_PRESET_UPPERLEFT);  break;
  }

  DestroyMenu(menu_);
}

////////////////////////////////////////////////////////////////////////////////
