#ifndef SWATCH_PALETTE_HPP
#define SWATCH_PALETTE_HPP


#include <afxwin.h>
#include <afxext.h>
#include "rgb.h"
#include "TilesetView.hpp"


class CSwatchPaletteHandler
{
public:
  virtual void SP_ColorSelected(RGBA color) = 0;
};


class CSwatchPalette : public CMiniFrameWnd
{
public:
  CSwatchPalette(CWnd* parent, CSwatchPaletteHandler* handler, CStatusBar* status_bar);
  ~CSwatchPalette();
  
  void UpdateColor(RGB color);
  void UpdateAlpha(byte alpha);
private:
  afx_msg void OnClose();
  afx_msg void OnSize(UINT type, int cx, int cy);
  afx_msg void OnPaint();
  afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
  afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnMouseMove(UINT nFlags, CPoint point);
  afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnFileLoad();
  afx_msg void OnFileSave();
  afx_msg void OnDefaultDOSPalette();
  afx_msg void OnDefaultVergePalette();

  void Generate_Colors();
  void UpdateScrollBar();
  int  GetPageSize();
  int  GetNumRows();

  void AddColor();
  void RemoveColor(int ColorRef);
private:
  bool                   m_Created;
  CSwatchPaletteHandler* m_Handler;
  CStatusBar*            m_StatusBar;
  CMenu                  m_Menu;

  int          m_NumColors;
  RGBA*        m_Color;

  int          m_TopRow;
  int          m_SelectedColor;
  RGBA         m_CVcolor;

  DECLARE_MESSAGE_MAP()
};


#endif
