#include <stdlib.h>
#include "StateServer.hpp"


CStateServer g_StateServer;


////////////////////////////////////////////////////////////////////////////////

CStateServer::CStateServer()
{
  CreateConfig(&m_Config);
}

////////////////////////////////////////////////////////////////////////////////

CStateServer::~CStateServer()
{
  DestroyConfig(&m_Config);
}

////////////////////////////////////////////////////////////////////////////////

void
CStateServer::Load(const char* filename)
{
  DestroyConfig(&m_Config);
  LoadConfig(&m_Config, filename);
}

////////////////////////////////////////////////////////////////////////////////

void
CStateServer::Save(const char* filename)
{
  SaveConfig(&m_Config, filename);
}

////////////////////////////////////////////////////////////////////////////////

int
CStateServer::GetInt(const char* key, int def)
{
  int i;
  ReadConfigInt(&m_Config, "states", key, &i, def);
  return i;
}

////////////////////////////////////////////////////////////////////////////////

void
CStateServer::SetInt(const char* key, int val)
{
  WriteConfigInt(&m_Config, "states", key, val);
}

////////////////////////////////////////////////////////////////////////////////

void
CStateServer::GetString(const char* key, char* string, int max_length, const char* def)
{
  ReadConfigString(&m_Config, "states", key, string, max_length, def);
}

////////////////////////////////////////////////////////////////////////////////

void
CStateServer::SetString(const char* key, const char* string)
{
  WriteConfigString(&m_Config, "states", key, string);
}

////////////////////////////////////////////////////////////////////////////////

CStateServer* GetStateServer()
{
  return &g_StateServer;
}

////////////////////////////////////////////////////////////////////////////////
