#ifndef SCROLL_WINDOW_HPP
#define SCROLL_WINDOW_HPP


#include <afxwin.h>


class CScrollWindow : public CWnd
{
public:
  CScrollWindow();

protected:
  void SetHScrollRange(int min, int max, int page);
  void SetVScrollRange(int min, int max, int page);

private:
  afx_msg void OnHScroll(UINT code, UINT pos, CScrollBar* scroll_bar);
  afx_msg void OnVScroll(UINT code, UINT pos, CScrollBar* scroll_bar);

  virtual void OnHScrollChanged(int x) = 0;
  virtual void OnVScrollChanged(int y) = 0;

private:
  int m_XMinimum;
  int m_XMaximum;
  int m_XPage;
  int m_XPosition;

  int m_YMinimum;
  int m_YMaximum;
  int m_YPage;
  int m_YPosition;
  
  DECLARE_MESSAGE_MAP()
};


#endif
