#include "ScrollWindow.hpp"


BEGIN_MESSAGE_MAP(CScrollWindow, CWnd)

  ON_WM_HSCROLL()
  ON_WM_VSCROLL()

END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////////

CScrollWindow::CScrollWindow()
: m_XMinimum(0)
, m_XMaximum(0)
, m_XPage(0)
, m_XPosition(0)

, m_YMinimum(0)
, m_YMaximum(0)
, m_YPage(0)
, m_YPosition(0)
{
}

////////////////////////////////////////////////////////////////////////////////

void
CScrollWindow::SetHScrollRange(int min, int max, int page)
{
  m_XMinimum = min;
  m_XMaximum = max;
  m_XPage    = page;

  SCROLLINFO si;
  si.cbSize = sizeof(si);
  si.fMask  = SIF_ALL;

  if (page < max - min)
  {
    si.nMin  = min;
    si.nMax  = max;
    si.nPage = page;
    si.nPos  = m_XPosition;
    SetScrollInfo(SB_HORZ, &si);
  }
  else
  {
    si.nMin  = 0;
    si.nMax  = 0xFFFF;
    si.nPage = 0xFFFE;
    si.nPos  = 0;
    SetScrollInfo(SB_HORZ, &si);
  }
}

////////////////////////////////////////////////////////////////////////////////

void
CScrollWindow::SetVScrollRange(int min, int max, int page)
{
  m_YMinimum = min;
  m_YMaximum = max;
  m_YPage    = page;

  SCROLLINFO si;
  si.cbSize = sizeof(si);
  si.fMask  = SIF_ALL;

  if (page < max - min)
  {
    si.nMin   = min;
    si.nMax   = max;
    si.nPage  = page;
    si.nPos   = m_YPosition;
    SetScrollInfo(SB_VERT, &si);
  }
  else
  {
    si.nMin  = 0;
    si.nMax  = 0xFFFF;
    si.nPage = 0xFFFE;
    si.nPos  = 0;
    SetScrollInfo(SB_VERT, &si);
  }
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CScrollWindow::OnHScroll(UINT code, UINT pos, CScrollBar* scroll_bar)
{
  switch (code)
  {
    case SB_LEFT:          m_XPosition = m_XMinimum; break;
    case SB_RIGHT:         m_XPosition = m_XMaximum; break;
    case SB_PAGELEFT:      m_XPosition -= m_XPage;   break;
    case SB_PAGERIGHT:     m_XPosition += m_XPage;   break;
    case SB_LINELEFT:      m_XPosition--;            break;
    case SB_LINERIGHT:     m_XPosition++;            break;
    case SB_THUMBPOSITION: m_XPosition = pos;        break;
    case SB_THUMBTRACK:    m_XPosition = pos;        break;
  }

  if (m_XPosition > m_XMaximum - m_XPage)
    m_XPosition = m_XMaximum - m_XPage;
  if (m_XPosition < m_XMinimum)
    m_XPosition = m_XMinimum;

  SetHScrollRange(m_XMinimum, m_XMaximum, m_XPage);
  OnHScrollChanged(m_XPosition);
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CScrollWindow::OnVScroll(UINT code, UINT pos, CScrollBar* scroll_bar)
{
  switch (code)
  {
    case SB_TOP:           m_YPosition = m_YMinimum; break;
    case SB_BOTTOM:        m_YPosition = m_YMaximum; break;
    case SB_PAGEUP:        m_YPosition -= m_YPage;   break;
    case SB_PAGEDOWN:      m_YPosition += m_YPage;   break;
    case SB_LINEUP:        m_YPosition--;            break;
    case SB_LINEDOWN:      m_YPosition++;            break;
    case SB_THUMBPOSITION: m_YPosition = pos;        break;
    case SB_THUMBTRACK:    m_YPosition = pos;        break;
  }

  if (m_YPosition > m_YMaximum - m_YPage)
    m_YPosition = m_YMaximum - m_YPage;
  if (m_YPosition < m_YMinimum)
    m_YPosition = m_YMinimum;

  SetVScrollRange(m_YMinimum, m_YMaximum, m_YPage);
  OnVScrollChanged(m_YPosition);
}

////////////////////////////////////////////////////////////////////////////////
