#ifndef SCRIPT_WINDOW_HPP
#define SCRIPT_WINDOW_HPP


#include "SaveableDocumentWindow.hpp"
#include "ScriptView.hpp"


class CScriptWindow 
 : public CSaveableDocumentWindow
 , private CScriptViewHandler
{
public:
  CScriptWindow(CStatusBar* status_bar);
  CScriptWindow(CStatusBar* status_bar, const char* filename);
  ~CScriptWindow();

private:
  void Create();

  bool LoadScript(const char* filename);

  afx_msg void OnSize(UINT yype, int cx, int cy);
  afx_msg void OnSetFocus(CWnd* old);

  afx_msg void OnScriptCheckSyntax();
  afx_msg void OnScriptFind();
  afx_msg void OnScriptReplace();

  virtual bool GetSavePath(char* path);
  virtual bool SaveDocument(const char* path);

  virtual void SV_ScriptChanged();

private:
  bool        m_Created;
  CScriptView m_Edit;
  CStatusBar* m_StatusBar;

  DECLARE_MESSAGE_MAP()
};


#endif
