#include "OptionsDialog.hpp"
#include "Audio.hpp"
#include "StateServer.hpp"
#include "resource.h"
#include "folderdialog.h"


BEGIN_MESSAGE_MAP(COptionsDialog, CDialog)

  ON_COMMAND(IDC_BROWSE,         OnBrowse)
  ON_COMMAND(IDC_CONFIGUREAUDIO, OnConfigureAudio)

  ON_COMMAND(IDC_REGISTER_RMP,   OnRegisterMap)
  ON_COMMAND(IDC_REGISTER_RSS,   OnRegisterSpriteset)
  ON_COMMAND(IDC_REGISTER_RWS,   OnRegisterWindowStyle)
  ON_COMMAND(IDC_REGISTER_RFN,   OnRegisterFont)

END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////////

COptionsDialog::COptionsDialog()
: CDialog(IDD_OPTIONS)
{
}

////////////////////////////////////////////////////////////////////////////////

void
COptionsDialog::RegisterFileType(const char* extension, const char* filetype)
{
  // get the executable name
  CWinApp* app = AfxGetApp();
  char exename[513];
  GetModuleFileName(app->m_hInstance, exename, 512);

  HKEY key;

  // register the extension
  RegCreateKey(HKEY_CLASSES_ROOT, extension, &key);
  RegSetValue(key, NULL, REG_SZ, filetype, strlen(filetype));
  RegCloseKey(key);

  // register the type
  RegCreateKey(HKEY_CLASSES_ROOT, filetype, &key);
  RegSetValue(key, "shell\\open\\command", REG_SZ, CString(exename) + " \"%1\"", strlen(exename) + 5);
  RegCloseKey(key);
}

////////////////////////////////////////////////////////////////////////////////

afx_msg BOOL
COptionsDialog::OnInitDialog()
{
  char sphere_directory[MAX_PATH];
  GetStateServer()->GetString("SphereDirectory", sphere_directory, MAX_PATH);
  SetDlgItemText(IDC_SPHEREDIRECTORY, sphere_directory);
  return TRUE;
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
COptionsDialog::OnOK()
{
  char folder[520];
  GetDlgItemText(IDC_SPHEREDIRECTORY, folder, 512);
  GetStateServer()->SetString("SphereDirectory", folder);

  CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
COptionsDialog::OnBrowse()
{
  char folder[MAX_PATH];
  if (BrowseForFolderDialog(m_hWnd, "Select Sphere Directory", folder))
    SetDlgItemText(IDC_SPHEREDIRECTORY, folder);
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
COptionsDialog::OnConfigureAudio()
{
  ConfigureAudio();
}

////////////////////////////////////////////////////////////////////////////////

#define REGISTER_HANDLER(name, ext, type)       \
afx_msg void                                    \
COptionsDialog::OnRegister##name()              \
{                                               \
  RegisterFileType(ext, type);                  \
}

REGISTER_HANDLER(Map,         ".rmp", "sdeMap");
REGISTER_HANDLER(Spriteset,   ".rss", "sdeSpriteset");
REGISTER_HANDLER(WindowStyle, ".rws", "sdeWindowStyle");
REGISTER_HANDLER(Font,        ".rfn", "sdeFont");

////////////////////////////////////////////////////////////////////////////////
