#ifndef MUSIC_WINDOW_HPP
#define MUSIC_WINDOW_HPP


#include <afxcmn.h>
#include "DocumentWindow.hpp"
#include "Audio.hpp"



class CMusicTrack : public CSliderCtrl
{
public:
  CMusicTrack();

private:
  afx_msg void OnLButtonDown(UINT flags, CPoint point);
  afx_msg void OnLButtonUp(UINT flags, CPoint poiint);

public:
  bool MouseDown;

  DECLARE_MESSAGE_MAP()
};



class CMusicWindow : public CDocumentWindow
{
public:
  CMusicWindow(const char* szMusic);
  ~CMusicWindow();

private:
  afx_msg void OnClose();
  afx_msg void OnSize(UINT uType, int cx, int cy);
  afx_msg void OnTimer(UINT uTimerID);
  afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar *pScrollBar);
  afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar *pScrollBar);
  afx_msg void OnMusicPlay();
  afx_msg void OnMusicStop();

private:
  CModule m_Module;
  CButton m_PlayButton;
  CButton m_StopButton;
  CMusicTrack m_VolumeBar;
  CMusicTrack m_MusicTrackBar;
  CStatic m_VolumeBarGraphic;
  CStatic m_Blank;

  CBitmap m_VolumeBarBitmap;

  DECLARE_MESSAGE_MAP()
};


#endif
