#include "MapPropertiesDialog.hpp"
#include "../common/Map.hpp"
#include "resource.h"



////////////////////////////////////////////////////////////////////////////////

CMapPropertiesDialog::CMapPropertiesDialog(sMap* map)
: CDialog(IDD_MAPPROPERTIES)
, m_Map(map)
{
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CMapPropertiesDialog::OnInitDialog()
{
  // set music file
  SetDlgItemText(IDC_MUSIC, m_Map->GetMusicFile());

  // set script file
  SetDlgItemText(IDC_SCRIPT, m_Map->GetScriptFile());

  return TRUE;
}

////////////////////////////////////////////////////////////////////////////////

void
CMapPropertiesDialog::OnOK()
{
  // get music file
  char music[512];
  GetDlgItemText(IDC_MUSIC, music, 500);
  m_Map->SetMusicFile(music);

  // get script file
  char script[512];
  GetDlgItemText(IDC_SCRIPT, script, 500);
  m_Map->SetScriptFile(script);
  
  CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////
