#ifndef LAYER_VIEW_HPP
#define LAYER_VIEW_HPP


#include <afxwin.h>
#include <afxext.h>


class sMap;  // #include "../sphere/common/Map.hpp"


class CLayerViewHandler
{
public:
  virtual void LV_MapChanged() = 0;
  virtual void LV_SelectedLayerChanged(int layer) = 0;
};


class CLayerView : public CWnd
{
public:
  CLayerView();
  ~CLayerView();

  BOOL Create(CStatusBar* pStatusBar, CLayerViewHandler* pHandler, CWnd* pParentWindow, sMap* pMap);

  int GetSelectedLayer() const;

  void SetSelectedTile(int iTile);

private:
  afx_msg void OnPaint();
  afx_msg void OnLButtonDown(UINT uFlags, CPoint Point);
  afx_msg void OnRButtonUp(UINT uFlags, CPoint Point);
  afx_msg void OnMouseMove(UINT nFlags, CPoint Point);

  afx_msg void OnToggleVisible();
  afx_msg void OnSetBaseLayer();
  afx_msg void OnInsertLayer();
  afx_msg void OnDeleteLayer();
  afx_msg void OnLayerProperties();
  afx_msg void OnLayerMoveUp();
  afx_msg void OnLayerMoveDown();
  afx_msg void OnLayerFill();

private:
  CStatusBar*        m_pStatusBar;
  CLayerViewHandler* m_pHandler;

  sMap* m_pMap;

  int m_iSelectedLayer;
  int m_iSelectedTile;

  DECLARE_MESSAGE_MAP();
};


#endif
