#include "LayerPropertiesDialog.hpp"
#include "resource.h"
#include "../common/Map.hpp"



////////////////////////////////////////////////////////////////////////////////

CLayerPropertiesDialog::CLayerPropertiesDialog(sLayer* pLayer)
: CDialog(IDD_LAYERPROPERTIES)
, m_pLayer(pLayer)
{
}

////////////////////////////////////////////////////////////////////////////////

CLayerPropertiesDialog::~CLayerPropertiesDialog()
{
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CLayerPropertiesDialog::OnInitDialog()
{
  // get handles to dialog controls
  m_pName   = (CEdit*)GetDlgItem(IDC_NAME);
  m_pWidth  = (CEdit*)GetDlgItem(IDC_WIDTH);
  m_pHeight = (CEdit*)GetDlgItem(IDC_HEIGHT);

  // set the default values in the dialog box
  m_pName->SetWindowText(m_pLayer->GetName());

  char szWidth[80];
  sprintf(szWidth, "%d", m_pLayer->GetWidth());
  m_pWidth->SetWindowText(szWidth);

  char szHeight[80];
  sprintf(szHeight, "%d", m_pLayer->GetHeight());
  m_pHeight->SetWindowText(szHeight);

  // give the name edit control focus and select all of the text
  m_pName->SetFocus();
  m_pName->SetSel(0, -1);

  return FALSE;  // we've set the focus
}

////////////////////////////////////////////////////////////////////////////////

void
CLayerPropertiesDialog::OnOK()
{
  CString name;
  m_pName->GetWindowText(name);
  m_pLayer->SetName(name);

  int width = GetDlgItemInt(IDC_WIDTH);
  int height = GetDlgItemInt(IDC_HEIGHT);

  if (width < 1 || width > 4096 ||
      height < 1 || height > 4096)
  {
    MessageBox("width and height must be between 1 and 4096");
    return;
  }

  m_pLayer->Resize(width, height);

  // close the dialog
  CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////
