#ifndef IMAGE_WINDOW_HPP
#define IMAGE_WINDOW_HPP


#include <afxcmn.h>
#include "SaveableDocumentWindow.hpp"
#include "Image32.hpp"
#include "ImageView.hpp"
#include "PaletteView.hpp"
#include "ColorView.hpp"
#include "AlphaView.hpp"


class CImageWindow
  : public CSaveableDocumentWindow
  , private CImageViewHandler
  , private CPaletteViewHandler
  , private CColorViewHandler
  , private CAlphaViewHandler
{
public:
  CImageWindow();
  CImageWindow(const char* image);
  ~CImageWindow();

private:
  void UpdateImageView();

  afx_msg void OnSize(UINT type, int cx, int cy);

  afx_msg void OnImageViewOriginalSize();
  afx_msg void OnImageSlideUp();
  afx_msg void OnImageSlideRight();
  afx_msg void OnImageSlideDown();
  afx_msg void OnImageSlideLeft();

  virtual bool GetSavePath(char* path);
  virtual bool SaveDocument(const char* path);

  // view handlers
  virtual void IV_ImageChanged();
  virtual void IV_ColorChanged(RGBA color);
  virtual void PV_ColorChanged(RGB color);
  virtual void CV_ColorChanged(RGB color);
  virtual void AV_AlphaChanged(byte alpha);

private:
  bool       m_Created;
  CImage32   m_Image;
  CImageView m_ImageView;

  CPaletteView m_PaletteView;
  CColorView   m_ColorView;
  CAlphaView   m_AlphaView;

  DECLARE_MESSAGE_MAP()
};


#endif
