#ifndef IMAGE_VIEW_HPP
#define IMAGE_VIEW_HPP


#include <afxwin.h>
#include "Image32.hpp"


class CImageViewHandler
{
public:
  virtual void IV_ImageChanged() = 0;
  virtual void IV_ColorChanged(RGBA color) = 0;
};


class CImageView : public CWnd
{
public:
  CImageView();
  ~CImageView();

  BOOL Create(CImageViewHandler* handler, CWnd* parent_window);

  bool        SetImage(const CImage32& image);
  bool        SetImage(int width, int height, const RGBA* pixels);
  int         GetWidth() const;
  int         GetHeight() const;
  RGBA*       GetPixels();
  const RGBA* GetPixels() const;

  void SetColor(RGBA color);
  RGBA GetColor() const;

  void FillRGB();
  void FillAlpha();

  bool Copy();
  bool Paste();

  bool CanUndo() const;
  void Undo();

private:
  void Click(int x, int y);
  void GetColor(RGBA* color, int x, int y);

  void AddUndoState();
  void ResetUndoStates();

  afx_msg void OnPaint();
  afx_msg void OnSize(UINT type, int cx, int cy);
  afx_msg void OnLButtonDown(UINT flags, CPoint point);
  afx_msg void OnLButtonUp(UINT flags, CPoint point);
  afx_msg void OnRButtonDown(UINT flags, CPoint point);
  afx_msg void OnMouseMove(UINT flags, CPoint point);

private:
  struct Image
  {
    int width, height;
    RGBA* pixels;
  };

private:
  CImageViewHandler* m_Handler;

  int   m_Width;
  int   m_Height;
  RGBA* m_Pixels;

  RGBA m_Color;

  bool m_MouseDown;

  int    m_NumUndoImages;
  Image* m_UndoImages;

  DECLARE_MESSAGE_MAP()
};


#endif
