#include <stdlib.h>
#include <string.h>
#include "FileTypes.hpp"


static const char* Extensions[] = {
  /* maps */         "1\0.rmp",
  /* spriteset */    "1\0.rss",
  /* scripts */      "1\0.js",
  /* sounds */       "1\0.wav",
  /* music */        "7\0.midi\0.mid\0.it\0.xm\0.s3m\0.mod\0.mp3",
  /* fonts */        "1\0.rfn",
  /* windowstyles */ "1\0.rws",
  /* images */       "3\0.png\0.pcx\0.bmp",
  /* animations */   "3\0.flic\0.fli\0.flc",
};

////////////////////////////////////////////////////////////////////////////////

int GetNumExtensions(int file_type)
{
  return atoi(Extensions[file_type]);
}

////////////////////////////////////////////////////////////////////////////////

const char* GetExtension(int file_type, int i)
{
  const char* p = Extensions[file_type];
  for (int j = 0; j < i; j++)
    p += strlen(p) + 1;
  return p + strlen(p) + 1;
}

////////////////////////////////////////////////////////////////////////////////
