#ifndef FILE_DIALOGS_HPP
#define FILE_DIALOGS_HPP


#include <afxdlgs.h>


enum EFileDialogMode { FDM_OPEN, FDM_SAVE };


#define DEFINE_FILE_DIALOG(name)                        \
class name : public CFileDialog                         \
{                                                       \
public:                                                 \
  name(EFileDialogMode Mode, bool bMustExist = true, bool bMultiSelectnOverWritePrompt = false); \
};                                           


DEFINE_FILE_DIALOG(CMapFileDialog)
DEFINE_FILE_DIALOG(CTilesetFileDialog)
DEFINE_FILE_DIALOG(CSpritesetFileDialog)
DEFINE_FILE_DIALOG(CMusicFileDialog)
DEFINE_FILE_DIALOG(CSoundFileDialog)
DEFINE_FILE_DIALOG(CScriptFileDialog)
DEFINE_FILE_DIALOG(CImageFileDialog)
DEFINE_FILE_DIALOG(CAnimationFileDialog)
DEFINE_FILE_DIALOG(CWindowStyleFileDialog)
DEFINE_FILE_DIALOG(CFontFileDialog)
DEFINE_FILE_DIALOG(CImportFileDialog)
DEFINE_FILE_DIALOG(CDoodadFileDialog)



#endif
