#include "EntityWarpDialog.hpp"
#include "resource.h"


BEGIN_MESSAGE_MAP(CEntityWarpDialog, CDialog)

  ON_BN_CLICKED(IDC_DESTINATION, OnUseDestination)

END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////////

CEntityWarpDialog::CEntityWarpDialog(sWarpEntity& warp, const sTileset& tileset)
: CDialog(IDD_ENTITY_WARP)
, m_Warp(warp)
, m_Tileset(tileset)
{
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CEntityWarpDialog::OnInitDialog()
{
  SetDlgItemText(IDC_MAP,  m_Warp.m_DestinationMap.c_str());
  SetDlgItemInt(IDC_FADE,  m_Warp.m_Fade);

  bool use_destination = (m_Warp.m_DestinationX != -1);
  if (use_destination)
    CheckDlgButton(IDC_DESTINATION, BST_CHECKED);
  else
  {
    m_Warp.m_DestinationX = 0;
    m_Warp.m_DestinationY = 0;
    m_Warp.m_DestinationLayer = 0;
  }

  SetDlgItemInt(IDC_X,     m_Warp.m_DestinationX / m_Tileset.GetTileWidth());
  SetDlgItemInt(IDC_Y,     m_Warp.m_DestinationY / m_Tileset.GetTileHeight());
  SetDlgItemInt(IDC_LAYER, m_Warp.m_DestinationLayer);

  OnUseDestination();

  GetDlgItem(IDC_MAP)->SetFocus();
  return FALSE;
}

////////////////////////////////////////////////////////////////////////////////

void
CEntityWarpDialog::OnOK()
{
  char map[520];
  GetDlgItemText(IDC_MAP, map, 500);
  m_Warp.m_DestinationMap = map;
  m_Warp.m_Fade = GetDlgItemInt(IDC_FADE);

  if (IsDlgButtonChecked(IDC_DESTINATION))
  {
    int px = GetDlgItemInt(IDC_X) * m_Tileset.GetTileWidth();
    int py = GetDlgItemInt(IDC_Y) * m_Tileset.GetTileHeight();
    m_Warp.m_DestinationX = px;
    m_Warp.m_DestinationY = py;
    m_Warp.m_DestinationLayer = GetDlgItemInt(IDC_LAYER);
  }
  else
  {
    m_Warp.m_DestinationX = -1;
    m_Warp.m_DestinationY = -1;
    m_Warp.m_DestinationLayer = -1;
  }
  
  CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CEntityWarpDialog::OnUseDestination()
{
  BOOL enable;
  if (IsDlgButtonChecked(IDC_DESTINATION))
    enable = TRUE;
  else
    enable = FALSE;

  GetDlgItem(IDC_X)->EnableWindow(enable);
  GetDlgItem(IDC_Y)->EnableWindow(enable);
  GetDlgItem(IDC_LAYER)->EnableWindow(enable);
}

////////////////////////////////////////////////////////////////////////////////
