#include "EntityPersonDialog.hpp"
#include "resource.h"


BEGIN_MESSAGE_MAP(CEntityPersonDialog, CDialog)

  ON_CBN_SELCHANGE(IDC_MOVEMENT, UpdateControls)

END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////////

CEntityPersonDialog::CEntityPersonDialog(sPersonEntity& person)
: CDialog(IDD_ENTITY_PERSON)
, m_Person(person)
{
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CEntityPersonDialog::OnInitDialog()
{
  // initialize controls
  
  SendDlgItemMessage(IDC_MOVEMENT, CB_ADDSTRING, 0, (LPARAM)"Random");
  SendDlgItemMessage(IDC_MOVEMENT, CB_ADDSTRING, 0, (LPARAM)"Scripted");

  SendDlgItemMessage(IDC_DIRECTION, CB_ADDSTRING, 0, (LPARAM)"North");
  SendDlgItemMessage(IDC_DIRECTION, CB_ADDSTRING, 0, (LPARAM)"East");
  SendDlgItemMessage(IDC_DIRECTION, CB_ADDSTRING, 0, (LPARAM)"South");
  SendDlgItemMessage(IDC_DIRECTION, CB_ADDSTRING, 0, (LPARAM)"West");
  
  // put in the initial values
  
  SetDlgItemText(IDC_SPRITESET, m_Person.m_Spriteset.c_str());
  SendDlgItemMessage(IDC_MOVEMENT, CB_SETCURSEL, m_Person.m_MovementType);

  SendDlgItemMessage(IDC_DIRECTION, CB_SETCURSEL, m_Person.m_StartDirection);
  SetDlgItemInt(IDC_WALK_SPEED,    m_Person.m_WalkSpeed);
  SetDlgItemInt(IDC_WALK_DURATION, m_Person.m_WalkDuration);
  SetDlgItemInt(IDC_WALK_DELAY,    m_Person.m_WalkDelay);

  SetDlgItemText(IDC_SCRIPT, m_Person.m_MovementScript.c_str());

  CheckDlgButton(m_Person.m_DialogueType == sPersonEntity::FILE ? IDC_FILE : IDC_TEXT, BST_CHECKED);
  SetDlgItemText(IDC_DIALOGUE, m_Person.m_Dialogue.c_str());

  // now continue

  UpdateControls();

  // give spriteset edit box focus
  GetDlgItem(IDC_SPRITESET)->SetFocus();
  return FALSE;
}

////////////////////////////////////////////////////////////////////////////////

void
CEntityPersonDialog::OnOK()
{
  // store the data back into the entity
  char str[4096];

  GetDlgItemText(IDC_SPRITESET, str, 4096);
  m_Person.m_Spriteset = str;
  m_Person.m_MovementType = SendDlgItemMessage(IDC_MOVEMENT, CB_GETCURSEL);

  m_Person.m_StartDirection = SendDlgItemMessage(IDC_DIRECTION, CB_GETCURSEL);
  m_Person.m_WalkSpeed      = GetDlgItemInt(IDC_WALK_SPEED);
  m_Person.m_WalkDuration   = GetDlgItemInt(IDC_WALK_DURATION);
  m_Person.m_WalkDelay      = GetDlgItemInt(IDC_WALK_DELAY);

  GetDlgItemText(IDC_SCRIPT, str, 4096);
  m_Person.m_MovementScript = str;

  m_Person.m_DialogueType = (IsDlgButtonChecked(IDC_FILE) == BST_CHECKED ? sPersonEntity::FILE : sPersonEntity::TEXT);
  GetDlgItemText(IDC_DIALOGUE, str, 4096);
  m_Person.m_Dialogue = str;

  CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CEntityPersonDialog::UpdateControls()
{
  if (SendDlgItemMessage(IDC_MOVEMENT, CB_GETCURSEL) == 0)
  {
    GetDlgItem(IDC_DIRECTION    )->EnableWindow(TRUE);
    GetDlgItem(IDC_WALK_SPEED   )->EnableWindow(TRUE);
    GetDlgItem(IDC_WALK_DURATION)->EnableWindow(TRUE);
    GetDlgItem(IDC_WALK_DELAY   )->EnableWindow(TRUE);
    GetDlgItem(IDC_SCRIPT       )->EnableWindow(FALSE);
  }
  else
  {
    GetDlgItem(IDC_DIRECTION    )->EnableWindow(FALSE);
    GetDlgItem(IDC_WALK_SPEED   )->EnableWindow(FALSE);
    GetDlgItem(IDC_WALK_DURATION)->EnableWindow(FALSE);
    GetDlgItem(IDC_WALK_DELAY   )->EnableWindow(FALSE);
    GetDlgItem(IDC_SCRIPT       )->EnableWindow(TRUE);
  }
}

////////////////////////////////////////////////////////////////////////////////
