#include "EntityDoodadDialog.hpp"
#include "resource.h"


////////////////////////////////////////////////////////////////////////////////

CEntityDoodadDialog::CEntityDoodadDialog(sDoodadEntity& doodad)
: CDialog(IDD_ENTITY_DOODAD)
, m_Doodad(doodad)
{
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CEntityDoodadDialog::OnInitDialog()
{
  SendDlgItemMessage(IDC_ACTIVATION_METHOD, CB_ADDSTRING, 0, (LPARAM)"None");
  SendDlgItemMessage(IDC_ACTIVATION_METHOD, CB_ADDSTRING, 0, (LPARAM)"Door-style");
  SendDlgItemMessage(IDC_ACTIVATION_METHOD, CB_ADDSTRING, 0, (LPARAM)"Chest-style");

  SetDlgItemText(IDC_FILE, m_Doodad.m_SpritesetFile.c_str());
  SetDlgItemText(IDC_FUNCTION, m_Doodad.m_Function.c_str());
  CheckDlgButton(IDC_OBSTRUCTIVE, m_Doodad.m_Obstructive ? BST_CHECKED : BST_UNCHECKED);
  SendDlgItemMessage(IDC_ACTIVATION_METHOD, CB_SETCURSEL, m_Doodad.m_ActivationMethod);

  GetDlgItem(IDC_FILE)->SetFocus();
  return FALSE;
}

////////////////////////////////////////////////////////////////////////////////

void
CEntityDoodadDialog::OnOK()
{
  char doodad_file[MAX_PATH];
  GetDlgItemText(IDC_FILE, doodad_file, MAX_PATH);
  m_Doodad.m_SpritesetFile = doodad_file;

  char function[512];
  GetDlgItemText(IDC_FUNCTION, function, 500);
  m_Doodad.m_Function = function;

  m_Doodad.m_Obstructive = (IsDlgButtonChecked(IDC_OBSTRUCTIVE) == BST_CHECKED);
  m_Doodad.m_ActivationMethod = SendDlgItemMessage(IDC_ACTIVATION_METHOD, CB_GETCURSEL);

  CDialog::OnOK();
}

////////////////////////////////////////////////////////////////////////////////
