#include "Editor.hpp"
#include "MainWindow.hpp"
#include "Audio.hpp"
#include "StateServer.hpp"
#include "Debug.hpp"
#include "folderdialog.h"
#include "ScriptView.hpp"


CEditorApplication g_Application;


class CEditorCommandLineInfo : public CCommandLineInfo
{
public:
  CEditorCommandLineInfo(CMainWindow* mainwindow)
  : m_MainWindow(mainwindow)
  {
  }

private:
  void ParseParam(LPCTSTR parameter, BOOL /*flag*/, BOOL /*last*/)
  {
    // test extension type
    for (int i = 0; i < NUM_GROUP_TYPES; i++)
      for (int j = 0; j < GetNumExtensions(i); j++)
        if (ExtensionCompare(parameter, GetExtension(i, j)))
          m_MainWindow->OpenDocumentWindow(i, parameter);
  }

  int ExtensionCompare(const char* parameter, const char* extension)
  {
    return (strcmp_ci(parameter + strlen(parameter) - strlen(extension), extension));
  }

  CMainWindow* m_MainWindow;
};
  

////////////////////////////////////////////////////////////////////////////////

CEditorApplication::CEditorApplication()
: CWinApp("Sphere Editor")
{
  InitializeLog();
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CEditorApplication::InitInstance()
{
  // get the startup directory
  GetModuleFileName(m_hInstance, m_StartupDirectory, MAX_PATH);
  if (strrchr(m_StartupDirectory, '\\'))
    *strrchr(m_StartupDirectory, '\\') = 0;
  SetCurrentDirectory(m_StartupDirectory);

  // load the configuration
  GetStateServer()->Load("editor.ini");

  // if Sphere directory does not exist, set as program directory
  char sphere_directory[MAX_PATH];
  GetStateServer()->GetString("SphereDirectory", sphere_directory, MAX_PATH, "");
  if (strlen(sphere_directory) == 0)
  {
    char sphere_directory[MAX_PATH];
    GetModuleFileName(AfxGetApp()->m_hInstance, sphere_directory, MAX_PATH);
    *strrchr(sphere_directory, '\\') = 0;
    GetStateServer()->SetString("SphereDirectory", sphere_directory);
  }

  // create the main window
  CMainWindow* main_window = new CMainWindow();
  main_window->Create();
  m_pMainWnd = main_window;

  // parse the command line
  CEditorCommandLineInfo cli(main_window);
  ParseCommandLine(cli);

  return TRUE;
}

////////////////////////////////////////////////////////////////////////////////

int
CEditorApplication::ExitInstance()
{
  SetCurrentDirectory(m_StartupDirectory);
  GetStateServer()->Save("editor.ini");
  return 0;
}

////////////////////////////////////////////////////////////////////////////////
