#ifndef DOCUMENT_WINDOW_HPP
#define DOCUMENT_WINDOW_HPP


#include <afxwin.h>


#define WM_DW_CLOSING (WM_USER + 1000)


class CDocumentWindow : public CMDIChildWnd
{
public:
  CDocumentWindow(const char* document_path, int menu_resource, const CSize& min_size = CSize(0, 0));
  ~CDocumentWindow();

  virtual bool Close();

protected:
  BOOL Create(LPCTSTR class_name);
  static const char* GetDefaultWindowClass();
  
  void        SetDocumentPath(const char* path);
  const char* GetDocumentPath() const;
  virtual const char* GetDocumentTitle() const;

  void SetCaption(const char* caption);
  const char* GetCaption();
  virtual void UpdateWindowCaption();

  virtual bool IsSaveable() const;

  void AttachPalette(CWnd* palette);

  afx_msg void OnCreate(LPCREATESTRUCT cs);
  afx_msg void OnClose();
  afx_msg void OnSizing(UINT side, LPRECT rect);
  afx_msg void OnMDIActivate(BOOL activate, CWnd* active_window, CWnd* inactive_window);

  afx_msg void OnUpdateSaveableCommand(CCmdUI* cmdui);

private:
  char  m_DocumentPath[MAX_PATH];
  char  m_Caption[520];

  int   m_MenuResource;
  CSize m_MinSize;

  int    m_NumPalettes;
  CWnd** m_Palettes;

  DECLARE_MESSAGE_MAP()
};


#endif
