#ifndef DEBUG_HPP
#define DEBUG_HPP


#include "LogDispatcher.hpp"
#include "x++.hpp"


extern CLogDispatcher DebugLog__;


// logs the entry and exit of a block of code, indenting any log strings in the body
#define LOG_BLOCK(name) LogBlock__ log__block__(name);

// logs one line
#define LOG(x) { for (int i = 0; i < LogBlock__::NumTabs; i++) DebugLog__ << "    "; DebugLog__ << x; }


class LogBlock__
{
public:
  LogBlock__(const char* name)
  {
    m_Name = newstr(name);

    LOG('+' << m_Name << '\n')
    NumTabs++;
  }

  ~LogBlock__()
  {
    NumTabs--;
    LOG('-' << m_Name << '\n')

    delete[] m_Name;
  }

  char* m_Name;

  static int NumTabs;
};


extern void InitializeLog();


#endif
