#include <afxdlgs.h>
#include "ColorView.hpp"


BEGIN_MESSAGE_MAP(CColorView, CWnd)

  ON_WM_PAINT()
  ON_WM_LBUTTONDOWN()

END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////////

CColorView::CColorView()
: m_Color(rgbBlack)
{
}

////////////////////////////////////////////////////////////////////////////////

CColorView::~CColorView()
{
}

////////////////////////////////////////////////////////////////////////////////

BOOL
CColorView::Create(CColorViewHandler* pHandler, CWnd* pParentWindow, RGB Color)
{
  m_pHandler = pHandler;
  m_Color = Color;

  return CWnd::Create(
    AfxRegisterWndClass(0, LoadCursor(NULL, IDC_ARROW), NULL, LoadIcon(NULL, IDI_APPLICATION)),
    "CColorView",
    WS_CHILD | WS_VISIBLE,
    CRect(0, 0, 0, 0),
    pParentWindow,
    0);
}

////////////////////////////////////////////////////////////////////////////////

void
CColorView::SetColor(RGB color)
{
  m_Color = color;
  Invalidate();
}

////////////////////////////////////////////////////////////////////////////////

RGB
CColorView::GetColor() const
{
  return m_Color;
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CColorView::OnPaint()
{
  CPaintDC dc(this);
  CBrush* pBrush = new CBrush(RGB(m_Color.red, m_Color.green, m_Color.blue));

  // fill client rectangle with current color
  RECT ClientRect;
  GetClientRect(&ClientRect);
  dc.FillRect(&ClientRect, pBrush);

  pBrush->DeleteObject();
  delete pBrush;
}

////////////////////////////////////////////////////////////////////////////////

afx_msg void
CColorView::OnLButtonDown(UINT flags, CPoint point)
{
  CColorDialog ColorDialog(
    RGB(m_Color.red, m_Color.green, m_Color.blue),
    CC_ANYCOLOR | CC_FULLOPEN | CC_RGBINIT);
  if (ColorDialog.DoModal() == IDOK)
  {
    m_Color.red   = GetRValue(ColorDialog.GetColor());
    m_Color.green = GetGValue(ColorDialog.GetColor());
    m_Color.blue  = GetBValue(ColorDialog.GetColor());
    Invalidate();

    m_pHandler->CV_ColorChanged(m_Color);
  }
}

////////////////////////////////////////////////////////////////////////////////
