#ifndef AUDIO_HPP
#define AUDIO_HPP


#ifdef DMUSIC_LUV
  #include <dmusicc.h>
  #include <dmusici.h>
#endif
#include <fmod.h>


extern bool ConfigureAudio();

typedef enum { MUSIC_MOD, MUSIC_MP3, MUSIC_WAV, MUSIC_MIDI } MusicType;
typedef enum { SOUND_WAV, SOUND_RAW } SoundType;


class CModule
{
public:
  CModule();
  ~CModule();

  bool         Load(const char* filename);
  bool         Play();
  bool         Stop();
  unsigned int GetVolume();
  void         SetVolume(unsigned int Volume);
  unsigned int GetSongLength();
  unsigned int GetSongPos();
  void         SetSongPos(unsigned int Pos);

  bool         IsPlaying() const;
  char*        ModuleGetSongName();

public:
  MusicType m_MusicType;

private:
  bool         m_Loaded;
  unsigned int m_SongVolume;
  long         m_Channel;

  #ifdef DMUSIC_LUV
    // For directmusic only
    IDirectMusic              *m_DirectMusic;
    IDirectMusicLoader        *m_MidiLoader;
    IDirectMusicSegment       *m_MidiSegment;
    IDirectMusicSegmentState  *m_MidiSegmentState;
  #endif

  union {
    FMUSIC_MODULE *m_Module;
    FSOUND_STREAM *m_Stream;
    
    #ifdef DMUSIC_LUV 
      IDirectMusicPerformance *m_Midi;
    #endif
  } m_Music;
};


class CSample
{
public:
  CSample();
  ~CSample();

  bool Load(const char* filename);

  bool Play();
  bool Stop();

  bool IsPlaying() const;
  void SetVolume(unsigned int Volume);

public:
  SoundType m_SoundType;

private:
  bool          m_Loaded;
  long          m_Channel;
  int           m_SampleRate;
  unsigned int  m_SampleVolume;

  FSOUND_SAMPLE* m_Sample;
};


#endif
