#ifndef SPHERE_SCRIPT_HPP
#define SPHERE_SCRIPT_HPP


#include <time.h>
#include "x++.hpp"


class sCompileError
{
public:
  sCompileError(
    const char* message = "",
    const char* token = "",
    int token_start = 0,
    int token_line = 0)
  : m_Message(newstr(message))
  , m_Token(newstr(token))
  , m_TokenStart(token_start)
  , m_TokenLine(token_line)
  {
  }

  ~sCompileError()
  {
    delete[] m_Message;
    delete[] m_Token;
  }

  const char* GetMessage() const
  {
    return m_Message;
  }

  const char* GetToken() const
  {
    return m_Token;
  }

  int GetTokenStart() const
  {
    return m_TokenStart;
  }

  int GetTokenLine() const
  {
    return m_TokenLine;
  }

  void SetMessage(const char* message)
  {
    delete[] m_Message;
    m_Message = newstr(message);
  }

  void SetToken(const char* token)
  {
    delete[] m_Token;
    m_Token = newstr(token);
  }

  void SetTokenStart(int start)
  {
    m_TokenStart = start;
  }

  void SetTokenLine(int line)
  {
    m_TokenLine = line;
  }

private:
  char* m_Message;
  char* m_Token;
  int   m_TokenStart;
  int   m_TokenLine;
};


struct sTiming
{
  clock_t compile;
  clock_t assemble;
};


extern bool sCompileScript(const char* outfile, const char* infile, sCompileError& error, sTiming* timing);

extern bool SS_IsKeyword(const char* token);
extern bool SS_IsOperator(const char* token);
extern bool SS_IsSystemType(const char* token);
extern bool SS_IsSystemFunction(const char* token);


#endif
