#include "SS_Tables.hpp"
#include "x++.hpp"


////////////////////////////////////////////////////////////////////////////////


#define TYPE_COLOR   (TYPE_USER + 0)
#define TYPE_IMAGE   (TYPE_USER + 1)
#define TYPE_SURFACE (TYPE_USER + 2)
#define TYPE_FILE    (TYPE_USER + 3)


const SS_SYSTEM_TYPE g_SystemTypes[] =
{
  { "color",   "int red,int green,int blue,int alpha" },
  { "image",   "int $handle" },
  { "surface", "int $handle" },
  { "file",    "int $handle" },
};
const int g_NumSystemTypes = arraysize(g_SystemTypes);


////////////////////////////////////////////////////////////////////////////////


const SS_SYSTEM_FUNCTION g_SystemFunctions[] =
{
  // engine
  { 0x0100, "Exit",        TYPE_VOID, "" },
  { 0x0101, "ExitMessage", TYPE_VOID, "string" },
  { 0x0102, "ChangeMusic", TYPE_VOID, "string" },
  { 0x0103, "PlaySound",   TYPE_VOID, "string" },

  // timing
  { 0x0200, "GetTime", TYPE_INT,  "" },
  { 0x0201, "Delay",   TYPE_VOID, "int" },

  // input
  { 0x0300, "LockInput",          TYPE_VOID, "" },
  { 0x0301, "UnlockInput",        TYPE_VOID, "" },
  { 0x0302, "AnyKeyPressed",      TYPE_BOOL, "" },
  { 0x0303, "KeyPressed",         TYPE_BOOL, "int" },
  { 0x0304, "GetMouseX",          TYPE_INT,  "" },
  { 0x0305, "GetMouseY",          TYPE_INT,  "" },
  { 0x0306, "MouseButtonPressed", TYPE_BOOL, "int" },
  { 0x0307, "ClearKeyQueue",      TYPE_VOID, "" },
  { 0x0308, "KeysLeft",           TYPE_BOOL, "" },
  { 0x0309, "GetKey",             TYPE_INT,  "" },

  // graphics
  { 0x0400, "FlipScreen",           TYPE_VOID, "" },
  { 0x0401, "SetClippingRectangle", TYPE_VOID, "int,int,int,int" },
  { 0x0402, "ApplyColorMask",       TYPE_VOID, "color" },
  { 0x0403, "SetFrameRate",         TYPE_VOID, "int" },
  { 0x0404, "GetFrameRate",         TYPE_INT,  "" },
  { 0x0405, "GetScreenWidth",       TYPE_INT,  "" },
  { 0x0406, "GetScreenHeight",      TYPE_INT,  "" },
  { 0x0407, "ClearScreen",          TYPE_VOID, "" },
  
    // images  
    { 0x0500, "LoadImage",      TYPE_IMAGE, "string" },
    { 0x0501, "GrabImage",      TYPE_IMAGE, "int,int,int,int" },
    { 0x0502, "DestroyImage",   TYPE_VOID,  "image" },
    { 0x0503, "BlitImage",      TYPE_VOID,  "image,int,int" },
    { 0x0504, "GetImageWidth",  TYPE_INT,   "image" },
    { 0x0505, "GetImageHeight", TYPE_INT,   "image" },

    // text
    { 0x0600, "SetFont",      TYPE_VOID, "string" },
    { 0x0601, "SetTextColor", TYPE_VOID, "color" },
    { 0x0602, "DrawText",     TYPE_VOID, "int,int,string" },
    { 0x0603, "DrawTextBox",  TYPE_VOID, "int,int,int,int,int,string" },

    // windows
    { 0x0700, "SetWindowStyle", TYPE_VOID, "string" },
    { 0x0701, "DrawWindow",     TYPE_VOID, "int,int,int,int" },

    // effects
    { 0x0800, "FadeIn",  TYPE_VOID, "int" },
    { 0x0801, "FadeOut", TYPE_VOID, "int" },

  // map engine
  { 0x0900, "MapEngine",       TYPE_VOID, "" },
  { 0x0901, "ChangeMap",       TYPE_VOID, "string" },
  { 0x0902, "GetTile",         TYPE_INT,  "int,int,int" },
  { 0x0903, "SetTile",         TYPE_VOID, "int,int,int,int" },
  { 0x0904, "SetColorMask",    TYPE_VOID, "color,int" },
  { 0x0905, "AddFrameHook",    TYPE_VOID, "int,string" },
  { 0x0906, "RemoveFrameHook", TYPE_VOID, "string" },
  { 0x0907, "BindKey",         TYPE_VOID, "int,string" },
  { 0x0908, "UnbindKey",       TYPE_VOID, "int" },

    // party
    { 0x0A00, "ClearParty",        TYPE_VOID, "" },
    { 0x0A01, "AddPartyCharacter", TYPE_VOID, "string" },

    // persons
    { 0x0B00, "CreatePerson",       TYPE_VOID, "string,string,int,int" },
    { 0x0B01, "DestroyPerson",      TYPE_VOID, "string" },
    { 0x0B02, "SetPersonText",      TYPE_VOID, "string,string" },
    { 0x0B03, "WarpPerson",         TYPE_VOID, "string,int,int" },
    { 0x0B04, "QueuePersonCommand", TYPE_VOID, "string,string" },

    // doodads
    { 0x1600, "SetDoodadFrame",       TYPE_VOID, "int" },
    { 0x1601, "SetDoodadObstructive", TYPE_VOID, "bool" },

  // string
  { 0x0C00, "StringLength", TYPE_INT,    "string" },
  { 0x0C01, "StringWidth",  TYPE_INT,    "string" },
  { 0x0C02, "LeftString",   TYPE_STRING, "string,int" },
  { 0x0C03, "RightString",  TYPE_STRING, "string,int" },
  { 0x0C04, "MidString",    TYPE_STRING, "string,int,int" },
  { 0x0C05, "Character",    TYPE_STRING, "int" },
  { 0x0C06, "Ascii",        TYPE_INT,    "string" },

  // math
  { 0x0D00, "abs",    TYPE_FLOAT, "float" },
  { 0x0D01, "sin",    TYPE_FLOAT, "float" },
  { 0x0D02, "cos",    TYPE_FLOAT, "float" },
  { 0x0D03, "tan",    TYPE_FLOAT, "float" },
  { 0x0D04, "asin",   TYPE_FLOAT, "float" },
  { 0x0D05, "acos",   TYPE_FLOAT, "float" },
  { 0x0D06, "atan",   TYPE_FLOAT, "float" },
  { 0x0D07, "random", TYPE_INT,   "int,int" },

  // surfaces
  { 0x0E00, "CreateSurface",          TYPE_SURFACE, "int,int" },
  { 0x0E01, "DestroySurface",         TYPE_VOID,    "surface" },
  { 0x0E02, "CreateImageFromSurface", TYPE_IMAGE,   "surface" },

    // pen/brush
    { 0x0F00, "SetPenColor",   TYPE_VOID, "color" },
    { 0x0F01, "SetBrushColor", TYPE_VOID, "color" },

    // graphics primitives
    { 0x1000, "SetPixel",  TYPE_VOID, "surface,int,int" },
    { 0x1001, "Line",      TYPE_VOID, "surface,int,int,int,int" },
    { 0x1002, "Circle",    TYPE_VOID, "surface,int,int,int" },
    { 0x1003, "Rectangle", TYPE_VOID, "surface,int,int,int,int" },

  // colors
  { 0x1100, "BlendColors",         TYPE_COLOR, "color,color" },
  { 0x1101, "BlendColorsWeighted", TYPE_COLOR, "color,color,int" },
  { 0x1102, "CreateColor",         TYPE_COLOR, "int,int,int,int" },
  { 0x1103, "SystemColor",         TYPE_COLOR, "int" },

  // animation
  { 0x1200, "PlayAnimation", TYPE_VOID, "string" },

  // type conversion
  { 0x1300, "itos", TYPE_STRING, "int" },
  { 0x1301, "itof", TYPE_FLOAT,  "int" },
  { 0x1302, "stoi", TYPE_INT,    "string" },
  { 0x1303, "stof", TYPE_FLOAT,  "string" },
  { 0x1304, "ftoi", TYPE_INT,    "float" },
  { 0x1305, "ftos", TYPE_STRING, "float" },

  // files
  { 0x1400, "OpenFile",        TYPE_FILE,   "string" },
  { 0x1401, "CloseFile",       TYPE_VOID,   "file" },
  { 0x1402, "WriteFileInt",    TYPE_VOID,   "file,string,int" },
  { 0x1403, "WriteFileBool",   TYPE_VOID,   "file,string,bool" },
  { 0x1404, "WriteFileString", TYPE_VOID,   "file,string,string" },
  { 0x1405, "WriteFileFloat",  TYPE_VOID,   "file,string,float" },
  { 0x1406, "ReadFileInt",     TYPE_INT,    "file,string,int" },
  { 0x1407, "ReadFileBool",    TYPE_BOOL,   "file,string,bool" },
  { 0x1408, "ReadFileString",  TYPE_STRING, "file,string,string" },
  { 0x1409, "ReadFileFloat",   TYPE_FLOAT,  "file,string,float" },

  // menu
  { 0x1500, "AddMenuItem",    TYPE_VOID, "string" },
  { 0x1501, "VerticalMenu",   TYPE_INT,  "int,int,int,int,int" },
  { 0x1502, "HorizontalMenu", TYPE_INT,  "int,int,int,int,int" },
  { 0x1503, "SetMenuPointer", TYPE_VOID, "string" },
};
const int g_NumSystemFunctions = arraysize(g_SystemFunctions);


////////////////////////////////////////////////////////////////////////////////

const SS_SYSTEM_CONSTANTS g_SystemConstants[] =
{
  // keyboard input constants

  { "KEY_ESCAPE",     "1" },
  { "KEY_F1",         "2" },
  { "KEY_F2",         "3" },
  { "KEY_F3",         "4" },
  { "KEY_F4",         "5" },
  { "KEY_F5",         "6" },
  { "KEY_F6",         "7" },
  { "KEY_F7",         "8" },
  { "KEY_F8",         "9" },
  { "KEY_F9",         "10" },
  { "KEY_F10",        "11" },
  { "KEY_F11",        "12" },
  { "KEY_F12",        "13" },
  { "KEY_TILDE",      "14" },
  { "KEY_0",          "15" },
  { "KEY_1",          "16" },
  { "KEY_2",          "17" },
  { "KEY_3",          "18" },
  { "KEY_4",          "19" },
  { "KEY_5",          "20" },
  { "KEY_6",          "21" },
  { "KEY_7",          "22" },
  { "KEY_8",          "23" },
  { "KEY_9",          "24" },
  { "KEY_MINUS",      "25" },
  { "KEY_EQUALS",     "26" },
  { "KEY_BACKSPACE",  "27" },
  { "KEY_TAB",        "28" },
  { "KEY_A",          "29" },
  { "KEY_B",          "30" },
  { "KEY_C",          "31" },
  { "KEY_D",          "32" },
  { "KEY_E",          "33" },
  { "KEY_F",          "34" },
  { "KEY_G",          "35" },
  { "KEY_H",          "36" },
  { "KEY_I",          "37" },
  { "KEY_J",          "38" },
  { "KEY_K",          "39" },
  { "KEY_L",          "40" },
  { "KEY_M",          "41" },
  { "KEY_N",          "42" },
  { "KEY_O",          "43" },
  { "KEY_P",          "44" },
  { "KEY_Q",          "45" },
  { "KEY_R",          "46" },
  { "KEY_S",          "47" },
  { "KEY_T",          "48" },
  { "KEY_U",          "49" },
  { "KEY_V",          "50" },
  { "KEY_W",          "51" },
  { "KEY_X",          "52" },
  { "KEY_Y",          "53" },
  { "KEY_Z",          "54" },
  { "KEY_SHIFT",      "55" },
  { "KEY_CTRL",       "56" },
  { "KEY_ALT",        "57" },
  { "KEY_SPACE",      "58" },
  { "KEY_OPENBRACE",  "59" },
  { "KEY_CLOSEBRACE", "60" },
  { "KEY_SEMICOLON",  "61" },
  { "KEY_APOSTROPHE", "62" },
  { "KEY_COMMA",      "63" },
  { "KEY_PERIOD",     "64" },
  { "KEY_SLASH",      "65" },
  { "KEY_BACKSLASH",  "66" },
  { "KEY_ENTER",      "67" },
  { "KEY_INSERT",     "68" },
  { "KEY_DELETE",     "69" },
  { "KEY_HOME",       "70" },
  { "KEY_END",        "71" },
  { "KEY_PAGEUP",     "72" },
  { "KEY_PAGEDOWN",   "73" },
  { "KEY_UP",         "74" },
  { "KEY_RIGHT",      "75" },
  { "KEY_DOWN",       "76" },
  { "KEY_LEFT",       "77" },

  // colors

  { "BLACK",   "0" },
  { "GREY",    "1" },
  { "WHITE",   "2" },
  { "RED",     "3" },
  { "GREEN",   "4" },
  { "BLUE",    "5" },
  { "CYAN",    "6" },
  { "MAGENTA", "7" },
  { "YELLOW",  "8" },

  { "TRANSPARENT_BLACK",   "9" },
  { "TRANSPARENT_GREY",    "10" },
  { "TRANSPARENT_WHITE",   "11" },
  { "TRANSPARENT_RED",     "12" },
  { "TRANSPARENT_GREEN",   "13" },
  { "TRANSPARENT_BLUE",    "14" },
  { "TRANSPARENT_CYAN",    "15" },
  { "TRANSPARENT_MAGENTA", "16" },
  { "TRANSPARENT_YELLOW",  "17" },
};
const int g_NumSystemConstants = arraysize(g_SystemConstants);



////////////////////////////////////////////////////////////////////////////////


const SS_OPCODE g_Opcodes[] =
{
  // integer
  { "mov",    2, 0x00, VP_LVALUE, VP_RVALUE },
  { "add",    2, 0x01, VP_LVALUE, VP_RVALUE },
  { "sub",    2, 0x02, VP_LVALUE, VP_RVALUE },
  { "mul",    2, 0x03, VP_LVALUE, VP_RVALUE },
  { "div",    2, 0x04, VP_LVALUE, VP_RVALUE },
  { "mod",    2, 0x05, VP_LVALUE, VP_RVALUE },
  { "neg",    1, 0x06, VP_LVALUE, 0 },
  { "clr",    1, 0x07, VP_LVALUE, 0 },

  // integer comparison
  { "cmpe",   2, 0x10, VP_LVALUE, VP_RVALUE },
  { "cmpg",   2, 0x11, VP_LVALUE, VP_RVALUE },
  { "cmpge",  2, 0x12, VP_LVALUE, VP_RVALUE },
  { "cmpl",   2, 0x13, VP_LVALUE, VP_RVALUE },
  { "cmple",  2, 0x14, VP_LVALUE, VP_RVALUE },

  // string                    
  { "sload",  2, 0x20, VP_LVALUE, VP_LABEL },
  { "sfree",  1, 0x21, VP_LVALUE, 0 },
  { "smov",   2, 0x22, VP_LVALUE, VP_SRVALUE },
  { "sadd",   2, 0x23, VP_LVALUE, VP_SRVALUE },
  { "sclr",   1, 0x24, VP_LVALUE, 0 },

  // string comparison
  { "scmpe",  2, 0x30, VP_LVALUE, VP_SRVALUE },
  { "scmpg",  2, 0x31, VP_LVALUE, VP_SRVALUE },
  { "scmpge", 2, 0x32, VP_LVALUE, VP_SRVALUE },
  { "scmpl",  2, 0x33, VP_LVALUE, VP_SRVALUE },
  { "scmple", 2, 0x34, VP_LVALUE, VP_SRVALUE },

  // floating point
  { "fadd", 2, 0x40, VP_LVALUE, VP_RVALUE },
  { "fsub", 2, 0x41, VP_LVALUE, VP_RVALUE },
  { "fmul", 2, 0x42, VP_LVALUE, VP_RVALUE },
  { "fdiv", 2, 0x43, VP_LVALUE, VP_RVALUE },
  { "fneg", 1, 0x44, VP_LVALUE },

  // floating point comparison
  { "fcmpe",  2, 0x50, VP_LVALUE, VP_RVALUE },
  { "fcmpg",  2, 0x51, VP_LVALUE, VP_RVALUE },
  { "fcmpge", 2, 0x52, VP_LVALUE, VP_RVALUE },
  { "fcmpl",  2, 0x53, VP_LVALUE, VP_RVALUE },
  { "fcmple", 2, 0x54, VP_LVALUE, VP_RVALUE },

  // boolean
  { "and",    2, 0x60, VP_LVALUE, VP_RVALUE },
  { "or",     2, 0x61, VP_LVALUE, VP_RVALUE },
  { "xor",    2, 0x62, VP_LVALUE, VP_RVALUE },
  { "not",    1, 0x63, VP_LVALUE, 0 },

  // stack
  { "push",    1, 0x70, VP_RVALUE,  0 },
  { "pop",     1, 0x71, VP_LVALUE,  0 },
  { "call",    1, 0x72, VP_LABEL,   0 },
  { "ret",     0, 0x73, 0,          0 },
  { "syscall", 1, 0x74, VP_LITERAL, 0 },
  { "extcall", 1, 0x75, VP_LABEL,   0 },

  // jump
  { "jmp",  1, 0x80, VP_LABEL,  0 },
  { "jmpt", 2, 0x81, VP_RVALUE, VP_LABEL },
  { "jmpf", 2, 0x82, VP_RVALUE, VP_LABEL },

  // memory
  { "alloc",  2, 0x90, VP_LVALUE, VP_LITERAL },
  { "free",   1, 0x91, VP_LVALUE, 0 },

  // VM commands
  { "lc",        0, 0xA0, 0, 0 },
  { "ld",        0, 0xA1, 0, 0 },
  { "parameter", 0, 0xA2, 0, 0 },
};
const int g_NumOpcodes = arraysize(g_Opcodes);


////////////////////////////////////////////////////////////////////////////////
