#ifndef SS_LINKER_HPP
#define SS_LINKER_HPP


#include "SS_Types.hpp"
#include "SS_Internal.hpp"


struct sField
{
  sString type;
  sString name;
};


struct sLibraryUserType
{
  sString name;
  sVector<sField> fields;
};


struct sParameter
{
  sString type;
  sString name;
};


struct sLibraryFunction
{
  sString return_type;
  sString name;
  sVector<sParameter> parameters;
};


class sLibraryHeader
{
public:
  void Read(const char* name);

  int GetNumUserTypes() const;
  sLibraryUserType GetUserType(int i) const;

  int GetNumFunctions() const;
  sLibraryFunction GetFunction(int i) const;

private:
  void Parse(const char* text);

  bool IsAlpha(char c);
  bool IsDigit(char c);
  bool IsIdentifier(sString s);
  bool IsDataType(sString s);
  bool IsReturnType(sString s);

  sString cIdentifier();
  sString cDataType();
  sString cReturnType();

  void cHeader();
  void cUserType();
  void cFunction();

  void    Next();
  sString Token();
  void    Match(sString token);

private:
  sVector<sToken> Tokens;
  int CurrentToken;

  sVector<sLibraryUserType> UserTypes;
  sVector<sLibraryFunction> Functions;
};


#endif
