#ifndef LAYER_HPP
#define LAYER_HPP


class sLayer
{
public:
  sLayer();
  sLayer(int width, int height);
  sLayer(const sLayer& layer);
  ~sLayer();

  const sLayer& operator=(const sLayer& layer);

  void Resize(int width, int height);

  void SetName(const char* name);
  void SetSize(int x, int y);
  void SetTile(int x, int y, int tile);
  void SetParallaxX(int mult, int div);
  void SetParallaxY(int mult, int div);
  void SetScrollingX(int mult, int div);
  void SetScrollingY(int mult, int div);

  const char* GetName() const;
  int GetWidth() const;
  int GetHeight() const;
  int GetTile(int x, int y) const;
  int GetParallaxXMult() const;
  int GetParallaxXDiv() const;
  int GetParallaxYMult() const;
  int GetParallaxYDiv() const;
  int GetScrollingXMult() const;
  int GetScrollingXDiv() const;
  int GetScrollingYMult() const;
  int GetScrollingYDiv() const;

private:
  char* m_Name;

  int  m_Width;
  int  m_Height;
  int* m_Tiles;

  int m_ParallaxXMult;
  int m_ParallaxXDiv;
  int m_ParallaxYMult;
  int m_ParallaxYDiv;

  int m_ScrollingXMult;
  int m_ScrollingXDiv;
  int m_ScrollingYMult;
  int m_ScrollingYDiv;
};


inline void
sLayer::SetTile(int x, int y, int tile)
{
  m_Tiles[y * GetWidth() + x] = tile;
}


inline int
sLayer::GetWidth() const
{
  return m_Width;
}


inline int
sLayer::GetHeight() const
{
  return m_Height;
}


inline int
sLayer::GetTile(int x, int y) const
{
  return m_Tiles[y * GetWidth() + x];
}


#endif
