#ifndef FONT_HPP
#define FONT_HPP


#include "Image32.hpp"


typedef CImage32 sFontCharacter;


class sFont
{
public:
  sFont(int num_characters = 0, int width = 0, int height = 0);
  ~sFont();

  bool Load(const char* filename);
  bool Save(const char* filename) const;

  void  SetNumCharacters(int num_characters);

  int                   GetNumCharacters() const;
  sFontCharacter&       GetCharacter(int i);
  const sFontCharacter& GetCharacter(int i) const;

private:
  int             m_NumCharacters;
  sFontCharacter* m_Characters;
};

////////////////////////////////////////////////////////////////////////////////

inline int
sFont::GetNumCharacters() const
{
  return m_NumCharacters;
}

////////////////////////////////////////////////////////////////////////////////

inline sFontCharacter&
sFont::GetCharacter(int i)
{
  return m_Characters[i];
}

////////////////////////////////////////////////////////////////////////////////

inline const sFontCharacter&
sFont::GetCharacter(int i) const
{
  return m_Characters[i];
}

////////////////////////////////////////////////////////////////////////////////


#endif
