#ifndef ENTITIES_HPP
#define ENTITIES_HPP


#include <string>
using std::string;


// sEntity
struct sEntity
{
  enum EntityType {
    NONE,
    WARP,
    PERSON,
    TRIGGER,
    DOODAD,
  };

  sEntity();
  EntityType GetEntityType() const;

  int m_X;  // x coordinate (pixel)
  int m_Y;  // y coordinate (pixel)
  int m_Layer;

protected:
  EntityType m_EntityType;
};


// sWarp
struct sWarpEntity : sEntity
{
  sWarpEntity();

  string m_DestinationMap;
  int    m_DestinationX;
  int    m_DestinationY;
  int    m_DestinationLayer;
  int    m_Fade;
};


// sPerson
struct sPersonEntity : sEntity
{
  enum { RANDOM = 0, SCRIPTED = 1 };
  enum { UP = 0, RIGHT = 1, DOWN = 2, LEFT = 3 };
  enum { TEXT = 0, FILE = 1 };

  sPersonEntity();

  string m_Spriteset;
  int    m_MovementType;

  // random movement
  int m_StartDirection;
  int m_WalkSpeed;
  int m_WalkDuration;  // number of tiles to walk
  int m_WalkDelay;

  // scripted movement
  string m_MovementScript;

  // dialog
  int    m_DialogueType;   // 0 = embedded, 1 = file
  string m_Dialogue;       // if dialogue_type is 0, this is just the dialogue text
                           // if dialogue_type is 1, this is a filename with the text
};


// sTrigger
struct sTriggerEntity : sEntity
{
  sTriggerEntity();

  string m_Function;
};


// sDoodad
struct sDoodadEntity : sEntity
{
  enum { NONE = 0, DOOR = 1, CHEST = 2 };

  sDoodadEntity();

  string m_SpritesetFile;
  string m_Function;
  bool   m_Obstructive;
  int    m_ActivationMethod;
};


#endif
