implement flik;

// The TileImage function allows you to 'fill' the screen with an image.
// Notes:- Call the FlipScreen function afterwards to see the results. 

void TileImage(string filename)
{
  image i = LoadImage(filename);
  int x,y;
  int[2] max;
  max[0] = GetScreenHeight(); max[1] = GetScreenWidth();

  while(y < max[1])
  {
      BlitImage(i,x,y);
      x+=GetImageWidth(i);
      if(x > max[0])
      {
          x=0;
          y+=GetImageHeight(i);
      }
  }
 
  DestroyImage(i); 
}

// The ImageWithText function is for drawing a characters face next to the text that the character is saying.
// Notes:- Call the FlipScreen function afterwards to see the results.
//         This function will be redefined soon. (5/3/00)

void ImageWithText(string filename, string text)
{

   DrawWindow(0,0, GetScreenWidth(),GetScreenHeight());
   image i = LoadImage(filename);
   BlitImage(i,0,0);
   DrawTextBox(0+GetImageWidth(i),0,GetScreenWidth()-GetImageWidth(i),GetScreenHeight(),0, text);  
   DestroyImage(i);
}

// The DisplayImage function is for drawing a image to the screen
// Notes:- It fades the image in, delays, then fades the image out.

void DisplayImage(string filename, int x, int y, int delay, int fadein, int fadeout)
{
   image i = LoadImage(filename);
   BlitImage(i,x,y);
   FadeIn(fadein);
   Delay(delay);
   FadeOut(fadeout);
   DestroyImage(i);
}

// The DisplayText function is for drawing text to the screen
// Notes:- It fades the text in, delays, then fades the text out.

void DisplayText(string text, int x, int y, int w, int h, int delay, int fadein, int fadeout)
{
   DrawTextBox(x,y,w,h,0, text);
   FadeIn(fadein);
   Delay(delay);
   FadeOut(fadeout);
}

// The 
// Notes:- 
//         

void ScrollText(string text, int time)
{
   SetFrameRate(0);
   image i = GrabImage(0,0,GetScreenWidth(),GetScreenHeight());
   SetFrameRate(60); //presume the original was 60

   int y = GetScreenHeight();
   while(y != 0-time)
   {
      BlitImage(i,0,0);
      DrawTextBox(0,y,GetScreenWidth(),GetScreenHeight(),0, text);
      FlipScreen();
      y-=1;
   }
   DestroyImage(i);
}


// The FadeOutTile function does exactly what it says on the tin.
// Notes:- Fades all the tiles in a row out.

void FadeOutTile()
{
   int x, y = 0;
   while(y < GetScreenHeight())
   {
      SetClippingRectangle(x,y,16,16);
      FadeOut(50);
      if(x < GetScreenWidth())
         x+=16;
      else
      {
         y+=16;
         x=0;
      }
   }
}


// The FadeOutTile function does exactly what it says on the tin.
// Notes:- Fades all the tiles in a row out.

color Colorize(int red, int blue, int green, int alpha)
{
   color custom;
   custom.red = red;
   custom.blue = blue;
   custom.green = green;
   custom.alpha = alpha;
   return custom;
}