implement menu;

type Person
{
  string Name;
  string Class;
  bool MagicUser;

  int Level;
  int EXP;
  int Next;

  int Curr_HP;
  int MAX_HP;

  int STR;
  int AGL;
  int INT;
  int VIT;
  int Luck;

  int Damage;
  int Hit;
  int Absorb;
  int Evade;

  int[8] Magic;
  int[8] MagicMAX;
}


Person[4] Heroes;


void MainMenu()
{
  Heroes[0] = CreatePlayer("Wolf", "FIGHTER", false);
  Heroes[1] = CreatePlayer("Hank", "Bl.Belt", false);
  Heroes[2] = CreatePlayer("Rosa", "Wh.Mage", true);
  Heroes[3] = CreatePlayer("Xain", "Bl.Mage", true);

  ClearScreen();
  while(AnyKeyPressed())
    ;

  DrawMainMenuForm();
  DrawMainMenu();

  FlipScreen();

  while(!AnyKeyPressed())
    if(KeyPressed(KEY_ENTER))
      MainMenu();
}

Person CreatePlayer(string aName, string aClass, bool aMagicUser)
{
  Person mReturn;

  mReturn.Name      = aName;
  mReturn.Class     = aClass;
  mReturn.MagicUser = aMagicUser;

  mReturn.Level = 1;
  mReturn.EXP   = 0;
  mReturn.Next  = 100;

  mReturn.Curr_HP   = random(1,25);
  mReturn.MAX_HP    = mReturn.Curr_HP;

  mReturn.STR    = 22;
  mReturn.AGL    = 5;
  mReturn.INT    = 1;
  mReturn.VIT    = 11;
  mReturn.Luck   = 5;

  mReturn.Damage = 18;
  mReturn.Hit    = 13;
  mReturn.Absorb = 1;
  mReturn.Evade  = 53;

  int i;
  for (i = 0; i < 8; i += 1) {
    mReturn.Magic[i] = 8;
    mReturn.MagicMAX[i] = 8;
  }

  return mReturn;
}

void MasterMenu()
{
  SetTextColor(SystemColor(WHITE));
  AddMenuItem("Status");
  AddMenuItem("Main");
  AddMenuItem("Exit");
  ClearScreen();
  int command = VerticalMenu(16, 16, 64, 48, 16);
  switch (command)
  {
    case (0) StatsMenu();
    case (1) MainMenu();
    case (2) Exit();
  }
}


void StatsMenu()
{
  while(AnyKeyPressed())
    ;

  int i;
  for (i = 0; i < 4; i += 1) {
    AddMenuItem(Heroes[i].Name);
  }
  int mCommand = VerticalMenu(18,15,64,64,16);
  if (mCommand != -1) {
    ClearScreen();
    DrawStatsForm();
    DrawStats(Heroes[mCommand]);
  }

  FlipScreen();
  while(!AnyKeyPressed())
  {
    if(KeyPressed(KEY_ENTER))
      MainMenu();
  }
}


void DrawMainMenuForm()
{
  //Draw ORB's Window
  DrawWindow(18,15,64,64);
  //Draw Gold Windom
  DrawWindow(10,97,80,24);

  //Top Left Player
    DrawWindow(109,15,88,96);

  //Top Right Player
    DrawWindow(217,15,88,96);

  //Bottom Left Player
    DrawWindow(109,131,88,96);

  //Bottom Right Player
    DrawWindow(217,131,88,96);

  //Draw Labels
  //Gold
    DrawText(80,97+8,"G");

  //Top Left
/*
  {
    DrawText(109,35,"L");
    DrawText(109,50,"HP");
    if(Heroes[0].MagicUser)
    {
      DrawText(109,80,"MAGIC");
        DrawText(109+(16*0),90,itos(gHero_1.oMagic_1));
        DrawText(109+(16*1),90,itos(gHero_1.oMagic_2));
        DrawText(109+(16*2),90,itos(gHero_1.oMagic_3));
        DrawText(109+(16*3),90,itos(gHero_1.oMagic_4));
        DrawText(109,90," / / / /");

        DrawText(109+(16*0),100,itos(gHero_1.oMagic_5));
        DrawText(109+(16*1),100,itos(gHero_1.oMagic_6));
        DrawText(109+(16*2),100,itos(gHero_1.oMagic_7));
        DrawText(109+(16*3),100,itos(gHero_1.oMagic_8));
        DrawText(109,100," / / /");
    }
  }

  DrawStringWidth(0,0,White,"/");

  //Top Right
  {
    DrawText(217,35,"L");
    DrawText(217,50,"HP");
    if(gHero_2.oMagicUser)
    {
      DrawText(217,80,"MAGIC");
        DrawText(217+(16*0),90,itos(gHero_2.oMagic_1));
        DrawText(217+(16*1),90,itos(gHero_2.oMagic_2));
        DrawText(217+(16*2),90,itos(gHero_2.oMagic_3));
        DrawText(217+(16*3),90,itos(gHero_2.oMagic_4));
        DrawText(217,90," / / / /");

        DrawText(217+(16*0),100,itos(gHero_2.oMagic_5));
        DrawText(217+(16*1),100,itos(gHero_2.oMagic_6));
        DrawText(217+(16*2),100,itos(gHero_2.oMagic_7));
        DrawText(217+(16*3),100,itos(gHero_2.oMagic_8));
        DrawText(217,100," / / /");
    }
  }

  //Bottom Left
  {
    DrawText(109,151,"L");
    DrawText(109,166,"HP");
    if(gHero_3.oMagicUser)
    {
      DrawText(109,196,"MAGIC");
        DrawText(109+(16*0),206,itos(gHero_3.oMagic_1));
        DrawText(109+(16*1),206,itos(gHero_3.oMagic_2));
        DrawText(109+(16*2),206,itos(gHero_3.oMagic_3));
        DrawText(109+(16*3),206,itos(gHero_3.oMagic_4));
        DrawText(109,206," / / / /");

        DrawText(109+(16*0),216,itos(gHero_3.oMagic_5));
        DrawText(109+(16*1),216,itos(gHero_3.oMagic_6));
        DrawText(109+(16*2),216,itos(gHero_3.oMagic_7));
        DrawText(109+(16*3),216,itos(gHero_3.oMagic_8));
        DrawText(109,216," / / /");
    }
  }

  //Bottom Right
  {
    DrawText(217,151,"L");
    DrawText(217,166,"HP");
    if(gHero_4.oMagicUser)
    {
      DrawText(217,196,"MAGIC");
        DrawText(217+(16*0),206,itos(gHero_4.oMagic_1));
        DrawText(217+(16*1),206,itos(gHero_4.oMagic_2));
        DrawText(217+(16*2),206,itos(gHero_4.oMagic_3));
        DrawText(217+(16*3),206,itos(gHero_4.oMagic_4));
        DrawText(217,206," / / / /");

        DrawText(217+(16*0),216,itos(gHero_4.oMagic_5));
        DrawText(217+(16*1),216,itos(gHero_4.oMagic_6));
        DrawText(217+(16*2),216,itos(gHero_4.oMagic_7));
        DrawText(217+(16*3),216,itos(gHero_4.oMagic_8));
        DrawText(217,216," / / /");
    }
  }
*/

}

void DrawMainMenu()
{
/*
  //Top Left Player
  DrawText(109,20,Heroes[0].Name);
  DrawText(135-StringWidth(itos(gHero_1.oLevel)),35,itos(gHero_1.oLevel));

  DrawText(147-StringWidth(itos(gHero_1.oCurr_HP)),60,itos(gHero_1.oCurr_HP));
  DrawText(147,60,"/");
  DrawText(154,60,itos(gHero_1.oMAX_HP));

  //Top Right Player
  DrawText(217,20,gHero2_Name);
  DrawText(243-StringWidth(itos(gHero_2.oLevel)),35,itos(gHero_2.oLevel));

  DrawText(255-StringWidth(itos(gHero_2.oCurr_HP)),60,itos(gHero_2.oCurr_HP));
  DrawText(255,60,"/");
  DrawText(263,60,itos(gHero_2.oMAX_HP));

  //Bottom Left Player
  DrawText(109,136,gHero3_Name);
  DrawText(135-StringWidth(itos(gHero_3.oLevel)),151,itos(gHero_3.oLevel));

  DrawText(147-StringWidth(itos(gHero_3.oCurr_HP)),176,itos(gHero_3.oCurr_HP));
  DrawText(147,176,"/");
  DrawText(154,176,itos(gHero_3.oMAX_HP));

  //Bottom Right Player
  DrawText(217,136,gHero4_Name);
  DrawText(243-StringWidth(itos(gHero_4.oLevel)),151,itos(gHero_4.oLevel));

  DrawText(255-StringWidth(itos(gHero_4.oCurr_HP)),176,itos(gHero_4.oCurr_HP));
  DrawText(255,176,"/");
  DrawText(263,176,itos(gHero_4.oMAX_HP));

*/
  //Draw Menu
  AddMenuItem("ITEM");
  AddMenuItem("MAGIC");
  AddMenuItem("WEAPON");
  AddMenuItem("ARMOR");
  AddMenuItem("STATUS");
  AddMenuItem("EXIT");
  int command = VerticalMenu(18, 139, 64, 88, 16);
  switch(command)
  {
    case (0) ItemsMenu();
    case (1) MagicMenu();
    case (2) WeaponsMenu();
    case (3) ArmorMenu();
    case (4) StatsMenu();
    case (5) Exit();
  }
}

void DrawStatsForm()
{
  //Draw Name Window
  DrawWindow(11,10,64,24);
  //Draw Class Window
  DrawWindow(92,10,136,24);
  //Draw Level Window
  DrawWindow(245,10,64,24);

  //Draw EXP Window
  DrawWindow(24,75-24,272,64);

  //Draw Raw Stat Window
  DrawWindow(16,156-24,136,72+24);
  //Draw Calc Stat Window
  DrawWindow(169,156-24,136,72+24);

  //Draw Labels
  DrawText(245,16,"LEV");

  DrawText(24,75-12,"EXP POINTS");
  DrawText(24,75+12,"FOR LEV UP");

  DrawText(16,140+(18*0),"STR.");
  DrawText(16,140+(18*1),"AGL.");
  DrawText(16,140+(18*2),"INT.");
  DrawText(16,140+(18*3),"VIT.");
  DrawText(16,140+(18*4),"LUCK");

  DrawText(169,140+(18*0),"DAMAGE");
  DrawText(169,140+(18*1),"HIT %");
  DrawText(169,140+(18*2),"ABSORB");
  DrawText(169,140+(18*3),"EVADE %");
}

void DrawStats(Person aPlayer)
{
  DrawText(40-(StringWidth(aPlayer.Name)/2),16,aPlayer.Name);
  DrawText(136,16,aPlayer.Class);
  DrawText(280,16,itos(aPlayer.Level));

  DrawText(290-StringWidth(itos(aPlayer.EXP)), 75-12,itos(aPlayer.EXP));
  DrawText(290-StringWidth(itos(aPlayer.Next)),75+12,itos(aPlayer.Next));

  DrawText(146-StringWidth(itos(aPlayer.STR)), 140+(18*0),itos(aPlayer.STR));
  DrawText(146-StringWidth(itos(aPlayer.AGL)), 140+(18*1),itos(aPlayer.AGL));
  DrawText(146-StringWidth(itos(aPlayer.INT)), 140+(18*2),itos(aPlayer.INT));
  DrawText(146-StringWidth(itos(aPlayer.VIT)), 140+(18*3),itos(aPlayer.VIT));
  DrawText(146-StringWidth(itos(aPlayer.Luck)),140+(18*4),itos(aPlayer.Luck));

  DrawText(299-StringWidth(itos(aPlayer.Damage)),140+(18*0),itos(aPlayer.Damage));
  DrawText(299-StringWidth(itos(aPlayer.Hit)),   140+(18*1),itos(aPlayer.Hit));

  DrawText(299-StringWidth(itos(aPlayer.Absorb)),140+(18*2),itos(aPlayer.Absorb));
  DrawText(299-StringWidth(itos(aPlayer.Evade)), 140+(18*3),itos(aPlayer.Evade));

  image Image = LoadImage("Fighter.bmp");
//  BlitImage(Image,92,10);
  DestroyImage(Image);
}

void ItemsMenu()
{
  while(AnyKeyPressed())
    ;

  ClearScreen();

  DrawItemsForm();
  DrawItems();

  FlipScreen();
  while(!AnyKeyPressed())
  {
    if(KeyPressed(KEY_ENTER))
      MainMenu();
  }
}

void DrawItemsForm()
{
  //Inventory Window
    DrawWindow(20,25,280,152);
  //Description Window
    DrawWindow(20,196,280,32);
  //Item Window
    DrawWindow(20,10,64,16);

  //Draw Labels
    DrawText(34,13,"ITEM");
}

void DrawItems()
{
}

void MagicMenu()
{
  while(AnyKeyPressed())
    ;

  AddMenuItem(Heroes[0].Name);
  AddMenuItem(Heroes[1].Name);
  AddMenuItem(Heroes[2].Name);
  AddMenuItem(Heroes[3].Name);
  int mCommand = VerticalMenu(18,15,64,64, 16);
  if (mCommand != -1) {
    ClearScreen();
    DrawMagicForm(Heroes[mCommand]);
    DrawMagic();
  }
  FlipScreen();

  while(!AnyKeyPressed())
  {
    if(KeyPressed(KEY_ENTER))
      MainMenu();
  }
}

void DrawMagicForm(Person aHero)
{
/*
  //Magic Window
  DrawWindow(20,25,280,170);
  //Name Window
  DrawWindow(20,10,64,16);

  //Draw Labels
  DrawText(34,13,aHero.oName);

  DrawText(25,40, "L1:");
  DrawText(25,60, "L2:");
  DrawText(25,80, "L3:");
  DrawText(25,100,"L4:");
  DrawText(25,120,"L5:");
  DrawText(25,140,"L6:");
  DrawText(25,160,"L7:");
  DrawText(25,180,"L8:");

  //Current Magic Points
  DrawText(25+25+5,40, itos(aHero.oMagic_1));
  DrawText(25+25+5,60, itos(aHero.oMagic_2));
  DrawText(25+25+5,80, itos(aHero.oMagic_3));
  DrawText(25+25+5,100,itos(aHero.oMagic_4));
  DrawText(25+25+5,120,itos(aHero.oMagic_5));
  DrawText(25+25+5,140,itos(aHero.oMagic_6));
  DrawText(25+25+5,160,itos(aHero.oMagic_7));
  DrawText(25+25+5,180,itos(aHero.oMagic_8));

  //Dividers
    DrawText(25+25+10+5,40, "/");
    DrawText(25+25+10+5,60, "/");
    DrawText(25+25+10+5,80, "/");
    DrawText(25+25+10+5,100,"/");
    DrawText(25+25+10+5,120,"/");
    DrawText(25+25+10+5,140,"/");
    DrawText(25+25+10+5,160,"/");
    DrawText(25+25+10+5,180,"/");

  //MAX Magic Points
    DrawText(25+25+20+5,40, itos(aHero.oMagicMAX_1));
    DrawText(25+25+20+5,60, itos(aHero.oMagicMAX_2));
    DrawText(25+25+20+5,80, itos(aHero.oMagicMAX_3));
    DrawText(25+25+20+5,100,itos(aHero.oMagicMAX_4));
    DrawText(25+25+20+5,120,itos(aHero.oMagicMAX_5));
    DrawText(25+25+20+5,140,itos(aHero.oMagicMAX_6));
    DrawText(25+25+20+5,160,itos(aHero.oMagicMAX_7));
    DrawText(25+25+20+5,180,itos(aHero.oMagicMAX_8));
*/
}

void DrawMagic()
{
}

void WeaponsMenu()
{
  while(AnyKeyPressed())
    ;

  ClearScreen();

  DrawWeaponsForm();
  DrawWeapons();

  FlipScreen();
  while(!AnyKeyPressed())
  {
    if(KeyPressed(KEY_ENTER))
      MainMenu();
  }
}

void DrawWeaponsForm()
{
  //Weapon Window
    DrawWindow(20,10,64,16);
  //Menu Window
    DrawWindow(20+64+18,10,208,16);
  //Equip Windows
    DrawWindow(102,44+((32+18)*0),208,32);
    DrawWindow(102,44+((32+18)*1),208,32);
    DrawWindow(102,44+((32+18)*2),208,32);
    DrawWindow(102,44+((32+18)*3),208,32);
  //Name Windows
    DrawWindow(20,44+((32+18)*0),72,16);
    DrawWindow(20,44+((32+18)*1),72,16);
    DrawWindow(20,44+((32+18)*2),72,16);
    DrawWindow(20,44+((32+18)*3),72,16);

  //Draw Labals
    DrawText(26,13,"WEAPON");
    
/*
DrawText((46-(StringWidth(gHero_1.oName)/2)),44+((32+18)*0),gHero_1.oName);
    
DrawText((46-(StringWidth(gHero_2.oName)/2)),44+((32+18)*1),gHero_2.oName);
    
DrawText((46-(StringWidth(gHero_3.oName)/2)),44+((32+18)*2),gHero_3.oName);
    
DrawText((46-(StringWidth(gHero_4.oName)/2)),44+((32+18)*3),gHero_4.oName);
*/

}

void DrawWeapons()
{
}

void ArmorMenu()
{
  while(AnyKeyPressed())
    ;

  ClearScreen();

  DrawArmorForm();
  DrawArmor();

  FlipScreen();
  while(!AnyKeyPressed())
  {
    if(KeyPressed(KEY_ENTER))
      MainMenu();
  }
}

void DrawArmorForm()
{
  //Armor Window
    DrawWindow(20,10,64,16);
  //Menu Window
    DrawWindow(20+64+18,10,208,16);
  //Equip Windows
    DrawWindow(102,44+((32+18)*0),208,32);
    DrawWindow(102,44+((32+18)*1),208,32);
    DrawWindow(102,44+((32+18)*2),208,32);
    DrawWindow(102,44+((32+18)*3),208,32);
  //Name Windows
    DrawWindow(20,44+((32+18)*0),72,16);
    DrawWindow(20,44+((32+18)*1),72,16);
    DrawWindow(20,44+((32+18)*2),72,16);
    DrawWindow(20,44+((32+18)*3),72,16);

  //Draw Labals
    DrawText(28,13,"ARMOR");
    
//DrawText((46-(StringWidth(gHero_1.oName)/2)),44+((32+18)*0),gHero_1.oName);
//DrawText((46-(StringWidth(gHero_2.oName)/2)),44+((32+18)*1),gHero_2.oName);
//DrawText((46-(StringWidth(gHero_3.oName)/2)),44+((32+18)*2),gHero_3.oName);
//DrawText((46-(StringWidth(gHero_4.oName)/2)),44+((32+18)*3),gHero_4.oName);

}

void DrawArmor()
{
}

void DrawStringWidth(int aX, int aY, color aTextColor, string aText)
{
  SetTextColor(aTextColor);
  DrawText(aX,aY,itos(StringWidth(aText)));
  FlipScreen();
}
