//Fixes by DaVince, 2007

var font = LoadFont("ff1.rfn");

RequireScript("color.js");
RequireSystemScript("menu.js");

function game()
{
  //SetFont("ff1.rfn");
  //SetWindowStyle("ff1.rws");
  intro();
  main_menu();
}


function intro()
{
  while (IsAnyKeyPressed())
    ;

/*
  // precache the colors (SetTextColor is normally slow if we don't do this)
  for (var i = 0; i < 256; i++) {
    SetTextColor(Color(255, 255, 255, i));
  }
*/

  LoadSound("../music/The Prelude 2.mid").play(true);

  SetFrameRate(60);

  var frame = 0;
  while (!IsAnyKeyPressed())
  {
    ApplyColorMask(Blue);

    // draw first text items
    draw_intro_string(32 + 0  * 16, frame - 0  * 256, "The world is veiled in");
    draw_intro_string(32 + 1  * 16, frame - 1  * 256, "darkness.  The wind stops,");
    draw_intro_string(32 + 2  * 16, frame - 2  * 256, "the sea is wild,");
    draw_intro_string(32 + 3  * 16, frame - 3  * 256, "and the earth begins to rot.");
    draw_intro_string(32 + 4  * 16, frame - 4  * 256, "The people wait,");
    draw_intro_string(32 + 5  * 16, frame - 5  * 256, "their only hope, a prophecy...");
    draw_intro_string(32 + 6  * 16, frame - 6  * 256, "'When the world is in darkness");
    draw_intro_string(32 + 7  * 16, frame - 7  * 256, "Four Warriors will come...'");
    draw_intro_string(32 + 8  * 16, frame - 8  * 256, "After a long journey, four");
    draw_intro_string(32 + 9  * 16, frame - 9  * 256, "young warriors arrive,");
    draw_intro_string(32 + 10 * 16, frame - 10 * 256, "each holding an ORB.'");

    FlipScreen();
    frame += 4;
  }
}


function draw_intro_string(y, offset, text)
{
  var text_color = CreateColor(255, 255, 255);

  if (offset < 0)
    text_color.alpha = 0;
  else if (offset > 255)
    text_color.alpha = 255;
  else
    text_color.alpha = offset;

  font.setColorMask(text_color);
  font.drawText(160 - font.getStringWidth(text) / 2, y, text);
}


function main_menu()
{
  font.setColorMask(White);
  var menu = new Menu();
  menu.addItem("New");
  menu.addItem("Load");
  menu.addItem("Exit");
  FlipScreen();
  var command = menu.execute(16, 16, 64, 48, 16);
  switch (command)
  {
    case 0: new_game();  break;
    case 1: load_game(); break;
    case 2: Exit();      break;
  }
}


function new_game()
{
  var done = false;
  while (!done)
  {
    FlipScreen();
    draw_player(48,  32);
    draw_player(48,  144);
    draw_player(192, 32);
    draw_player(192, 144);
    FlipScreen();

    // handle keypresses
    while (KeysLeft())
    {
      GetKey();
      done = true;
    }

  } // end while not done

  AddPartyCharacter("fighter.rss");
  ChangeMap("elfland.rmp");
  MapEngine();
}


function draw_player(x, y)
{
  DrawWindow(x, y, 80, 56);
  DrawText(x + 24, y + 10, "Player");
  DrawText(x + 8,  y + 40, "Class");
}


function load_game()
{
  var f = OpenFile("saved_games");
  var num_games = ReadFileInt(f, "num_saved_games", 0);
  CloseFile(f);

  if (num_games != 0)
  {
    
  }
  else
    ExitMessage("No games have been saved");
}
