function game()
{
  intro();
  battle();
}


function intro()
{
  ChangeMusic("clouds.mid");
  CenterFadeText(16, "Welcome to AegisKnight's Battle System!");
  CenterFadeText(32, "Credits:");
  CenterFadeText(48, "Code: AegisKnight @ 7:00 a.m.");
  CenterFadeText(64, "Music and Sounds: Bad Religion and Ben Garvey");
  CenterFadeText(80, "Art: AegisKnight's Mad Artist Skillz");
  CenterFadeText(96, "Have fun!");
}


function CenterFadeText(y, text)
{
  ClearScreen();
  DrawText((320 - StringWidth(text)) / 2, y, text);
  FadeIn(400);
  Delay(500);
  ClearScreen();
  DrawText((320 - StringWidth(text)) / 2, y, text);
  FadeOut(200);
}


function battle()
{
  ChangeMusic("Out of Hand.MP3");

  var background = LoadImage("background.png");
  var monster = LoadImage("monster.png");
  var arrow = LoadImage("pointer.png");

  var angle = 0.0;
  var r = 10.0;

  var player_turn = false;
  var frames_until_player_turn = 60;
  var choice = 0;

  SetFrameRate(60);

  var done = false;
  while (!done) {

    // update state logic
    frames_until_player_turn -= 1;
    if (frames_until_player_turn <= 0) {
      player_turn = true;
    }

    // display screen stuff
    background.blit(0, 0);
    monster.blit(32 + r * Math.sin(angle), 32 + r * Math.cos(angle));
    var q = 10.0 - r;
    monster.blit(200 + q * Math.cos(angle), 32 + q * Math.sin(angle));

    if (frames_until_player_turn <= 0) {
      DrawWindow(10, 160, 100, 100);
      SDrawText(10, 160, "Your turn:");
      SDrawText(26, 176, "Fight");
      SDrawText(26, 192, "Magic"); 
      SDrawText(26, 208, "Run");
      arrow.blit(10, 176 + 16 * choice);
    }

    FlipScreen();

    // update monster position
    angle += 0.1;
    r = 10.0 * Math.sin(angle / 10.0);

    // process input
    while (KeysLeft()) {
      switch (GetKey()) {

        case KEY_UP: {
          choice -= 1;
          if (choice < 0) {
            choice = 2;
          }
          break;
        }

        case KEY_DOWN: {
          choice += 1;
          if (choice > 2) {
            choice = 0;
          }
          break;
        }

        case KEY_ENTER: {
          // execute choice
          switch (choice) {
            case 0: {  // fight
              PlaySound("Idon't.wav");

              player_turn = false;
              frames_until_player_turn = 60;
              choice = 0;
              break;
            }

            case 1: {  // magic
              player_turn = false;
              frames_until_player_turn = 60;
              choice = 0;
              break;
            }

            case 2: {  // run
              player_turn = false;
              frames_until_player_turn = 60;
              choice = 0;
              break;
            }
          }
          break;
        } 

        case KEY_ESCAPE: {
          done = true;
          break;
        }

      }
    }
  }
}

function SDrawText(x, y, s)
{
  SetTextColor(Black);
  DrawText(x + 1, y + 1, s);
  SetTextColor(White);
  DrawText(x, y, s);
}
