#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../../common/SphereScript.hpp"


int main(int argc, char** argv)
{
  if (argc != 2) {
    puts("scc <infile.ss>");
    return EXIT_FAILURE;
  }

  char* out_file = new char[strlen(argv[1]) + 10];
  strcpy(out_file, argv[1]);
  if (strrchr(out_file, '.'))
    *strrchr(out_file, '.') = 0;
  strcat(out_file, ".ssx");

  printf("Compiling '%s' to '%s'...", argv[1], out_file);

  sCompileError error;
  sTiming timing;
  if (!sCompileScript(out_file, argv[1], error, &timing)) {
    putchar('\n');
    printf("Error: Line: %d - %s\n", error.GetTokenLine(), error.GetMessage());
    return EXIT_FAILURE;
  }

  printf("Success!\n"
         "  Compile: %d ms\n"
         "  Assemble: %d ms\n",
    1000 * timing.compile / CLOCKS_PER_SEC,
    1000 * timing.assemble / CLOCKS_PER_SEC);

  delete[] out_file;

  return EXIT_SUCCESS;
}
