#ifndef WIN32_VIDEO_H
#define WIN32_VIDEO_H


#include "types.h"
#include "colorspace.h"


typedef struct IMAGE__{int dummy__;}* IMAGE;


#include "begin_c_prototypes.h"

  extern bool SwitchResolution(int x, int y);
  extern int  GetScreenWidth(void);
  extern int  GetScreenHeight(void);

  extern bool FlipScreen(void);
  extern bool (__stdcall * SetClippingRectangle)(int x, int y, int w, int h);
  extern bool (__stdcall * GetClippingRectangle)(int* x, int* y, int* w, int* h);
  extern bool (__stdcall * ApplyColorMask)(RGBA mask);

  extern IMAGE (__stdcall * CreateImage)(int width, int height, RGBA* pixels);
  extern IMAGE (__stdcall * GrabImage)(int x, int y, int width, int height);
  extern bool  (__stdcall * DestroyImage)(IMAGE image);
  extern bool  (__stdcall * BlitImage)(IMAGE image, int x, int y);
  extern int   (__stdcall * GetImageWidth)(IMAGE image);
  extern int   (__stdcall * GetImageHeight)(IMAGE image);
  extern RGBA* (__stdcall * LockImage)(IMAGE image);
  extern void  (__stdcall * UnlockImage)(IMAGE image);
  extern void  (__stdcall * DirectBlit)(int x, int y, int w, int h, RGBA* pixels, int method);
  extern void  (__stdcall * DirectGrab)(int x, int y, int w, int h, RGBA* pixels);

#include "end_c_prototypes.h"


#endif
